/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.Collection;
import javax.annotation.Nullable;

class FloatOperator
extends SetValueOperator<Float> {
    FloatOperator(BaseRealm baseRealm, OsSet osSet, Class<Float> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(@Nullable Float value) {
        return this.osSet.add(value);
    }

    @Override
    boolean containsInternal(@Nullable Object o) {
        Float value = o == null ? null : (Float)o;
        return this.osSet.contains(value);
    }

    @Override
    boolean removeInternal(@Nullable Object o) {
        return this.osSet.remove((Float)o);
    }

    @Override
    boolean containsAllInternal(Collection<?> c) {
        Collection<?> floatCollection = c;
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newFloatCollection(floatCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends Float> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newFloatCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newFloatCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newFloatCollection(c);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }
}

