/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryRealmAnyOperator;
import io.realm.BooleanRealmAnyOperator;
import io.realm.DateRealmAnyOperator;
import io.realm.Decimal128RealmAnyOperator;
import io.realm.DoubleRealmAnyOperator;
import io.realm.DynamicRealmModelRealmAnyOperator;
import io.realm.FloatRealmAnyOperator;
import io.realm.IntegerRealmAnyOperator;
import io.realm.NullRealmAnyOperator;
import io.realm.ObjectIdRealmAnyOperator;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmModelOperator;
import io.realm.StringRealmAnyOperator;
import io.realm.UUIDRealmAnyOperator;
import io.realm.exceptions.RealmException;
import io.realm.internal.core.NativeRealmAny;
import javax.annotation.Nullable;

public abstract class RealmAnyOperator {
    @Nullable
    private NativeRealmAny nativeRealmAny;
    private RealmAny.Type type;

    static RealmAnyOperator fromNativeRealmAny(BaseRealm realm, NativeRealmAny nativeRealmAny) {
        RealmAny.Type fieldType = nativeRealmAny.getType();
        switch (fieldType) {
            case INTEGER: {
                return new IntegerRealmAnyOperator(nativeRealmAny);
            }
            case BOOLEAN: {
                return new BooleanRealmAnyOperator(nativeRealmAny);
            }
            case STRING: {
                return new StringRealmAnyOperator(nativeRealmAny);
            }
            case BINARY: {
                return new BinaryRealmAnyOperator(nativeRealmAny);
            }
            case DATE: {
                return new DateRealmAnyOperator(nativeRealmAny);
            }
            case FLOAT: {
                return new FloatRealmAnyOperator(nativeRealmAny);
            }
            case DOUBLE: {
                return new DoubleRealmAnyOperator(nativeRealmAny);
            }
            case DECIMAL128: {
                return new Decimal128RealmAnyOperator(nativeRealmAny);
            }
            case OBJECT_ID: {
                return new ObjectIdRealmAnyOperator(nativeRealmAny);
            }
            case UUID: {
                return new UUIDRealmAnyOperator(nativeRealmAny);
            }
            case OBJECT: {
                if (realm instanceof Realm) {
                    try {
                        Class clazz = nativeRealmAny.getModelClass(realm.sharedRealm, realm.configuration.getSchemaMediator());
                        return new RealmModelOperator(realm, nativeRealmAny, clazz);
                    }
                    catch (RealmException realmException) {
                        // empty catch block
                    }
                }
                return new DynamicRealmModelRealmAnyOperator(realm, nativeRealmAny);
            }
            case NULL: {
                return new NullRealmAnyOperator(nativeRealmAny);
            }
        }
        throw new ClassCastException("Couldn't cast to " + (Object)((Object)fieldType));
    }

    private synchronized NativeRealmAny getNativeRealmAny() {
        if (this.nativeRealmAny == null) {
            this.nativeRealmAny = this.createNativeRealmAny();
        }
        return this.nativeRealmAny;
    }

    long getNativePtr() {
        return this.getNativeRealmAny().getNativePtr();
    }

    protected abstract NativeRealmAny createNativeRealmAny();

    protected RealmAnyOperator(RealmAny.Type type) {
        this.type = type;
    }

    protected RealmAnyOperator(RealmAny.Type type, NativeRealmAny nativeRealmAny) {
        this.type = type;
        this.nativeRealmAny = nativeRealmAny;
    }

    abstract <T> T getValue(Class<T> var1);

    RealmAny.Type getType() {
        return this.type;
    }

    Class<?> getTypedClass() {
        return this.type.getTypedClass();
    }

    boolean coercedEquals(RealmAnyOperator realmAnyOperator) {
        return this.getNativeRealmAny().coercedEquals(realmAnyOperator.getNativeRealmAny());
    }

    public void checkValidObject(BaseRealm realm) {
    }
}

