/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.SetChangeSet;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObservableSet;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsCollection;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Table;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class OsSet
implements NativeObject,
OsCollection {
    public static final int NOT_FOUND = -1;
    private static final int VALUE_NOT_FOUND = 0;
    private static final int VALUE_FOUND = 1;
    private static final long nativeFinalizerPtr = OsSet.nativeGetFinalizerPtr();
    private final long nativePtr;
    private final NativeContext context;
    private final OsSharedRealm osSharedRealm;
    private final Table targetTable;

    public OsSet(UncheckedRow row, long columnKey) {
        this.osSharedRealm = row.getTable().getSharedRealm();
        long[] pointers = OsSet.nativeCreate(this.osSharedRealm.getNativePtr(), row.getNativePtr(), columnKey);
        this.nativePtr = pointers[0];
        this.context = this.osSharedRealm.context;
        this.context.addReference(this);
        this.targetTable = pointers[1] != 0L ? new Table(this.osSharedRealm, pointers[1]) : null;
    }

    private OsSet(OsSharedRealm osSharedRealm, long nativePtr, @Nullable Table targetTable) {
        this.osSharedRealm = osSharedRealm;
        this.nativePtr = nativePtr;
        this.context = osSharedRealm.context;
        this.targetTable = targetTable;
        this.context.addReference(this);
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    @Override
    public boolean isValid() {
        return OsSet.nativeIsValid(this.nativePtr);
    }

    public TableQuery getQuery() {
        return new TableQuery(this.context, this.targetTable, OsSet.nativeGetQuery(this.nativePtr));
    }

    public void deleteAll() {
        OsSet.nativeDeleteAll(this.nativePtr);
    }

    public Object getValueAtIndex(int position) {
        return OsSet.nativeGetValueAtIndex(this.nativePtr, position);
    }

    public long size() {
        return OsSet.nativeSize(this.nativePtr);
    }

    public boolean collectionFunnel(NativeRealmAnyCollection collection, ExternalCollectionOperation operation) {
        switch (operation) {
            case CONTAINS_ALL: {
                return OsSet.nativeContainsAllRealmAnyCollection(this.nativePtr, collection.getNativePtr());
            }
            case ADD_ALL: {
                return OsSet.nativeAddAllRealmAnyCollection(this.nativePtr, collection.getNativePtr());
            }
            case REMOVE_ALL: {
                return OsSet.nativeRemoveAllRealmAnyCollection(this.nativePtr, collection.getNativePtr());
            }
            case RETAIN_ALL: {
                return this.retainAllInternal(collection);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)operation));
    }

    public boolean contains(@Nullable Boolean value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsBoolean(this.nativePtr, value);
    }

    public boolean add(@Nullable Boolean value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddBoolean(this.nativePtr, value);
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Boolean value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveBoolean(this.nativePtr, value);
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable String value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsString(this.nativePtr, value);
    }

    public boolean add(@Nullable String value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddString(this.nativePtr, value);
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable String value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveString(this.nativePtr, value);
        return indexAndFound[1] == 1L;
    }

    public boolean add(@Nullable Integer value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddLong(this.nativePtr, value.longValue());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Integer value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveLong(this.nativePtr, value.longValue());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable Long value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsLong(this.nativePtr, value);
    }

    public boolean add(@Nullable Long value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddLong(this.nativePtr, value);
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Long value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveLong(this.nativePtr, value);
        return indexAndFound[1] == 1L;
    }

    public boolean add(@Nullable Short value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddLong(this.nativePtr, value.longValue());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Short value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveLong(this.nativePtr, value.longValue());
        return indexAndFound[1] == 1L;
    }

    public boolean add(@Nullable Byte value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddLong(this.nativePtr, value.longValue());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Byte value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveLong(this.nativePtr, value.longValue());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable Float value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsFloat(this.nativePtr, value.floatValue());
    }

    public boolean add(@Nullable Float value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddFloat(this.nativePtr, value.floatValue());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Float value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveFloat(this.nativePtr, value.floatValue());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable Double value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsDouble(this.nativePtr, value);
    }

    public boolean add(@Nullable Double value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddDouble(this.nativePtr, value);
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Double value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveDouble(this.nativePtr, value);
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable byte[] value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsBinary(this.nativePtr, value);
    }

    public boolean add(@Nullable byte[] value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddBinary(this.nativePtr, value);
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable byte[] value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveBinary(this.nativePtr, value);
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable Date value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsDate(this.nativePtr, value.getTime());
    }

    public boolean add(@Nullable Date value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddDate(this.nativePtr, value.getTime());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Date value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveDate(this.nativePtr, value.getTime());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable Decimal128 value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsDecimal128(this.nativePtr, value.getLow(), value.getHigh());
    }

    public boolean add(@Nullable Decimal128 value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddDecimal128(this.nativePtr, value.getLow(), value.getHigh());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable Decimal128 value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveDecimal128(this.nativePtr, value.getLow(), value.getHigh());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable ObjectId value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsObjectId(this.nativePtr, value.toString());
    }

    public boolean add(@Nullable ObjectId value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddObjectId(this.nativePtr, value.toString());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable ObjectId value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveObjectId(this.nativePtr, value.toString());
        return indexAndFound[1] == 1L;
    }

    public boolean contains(@Nullable UUID value) {
        if (value == null) {
            return OsSet.nativeContainsNull(this.nativePtr);
        }
        return OsSet.nativeContainsUUID(this.nativePtr, value.toString());
    }

    public boolean add(@Nullable UUID value) {
        long[] indexAndFound = value == null ? OsSet.nativeAddNull(this.nativePtr) : OsSet.nativeAddUUID(this.nativePtr, value.toString());
        return indexAndFound[1] != 0L;
    }

    public boolean remove(@Nullable UUID value) {
        long[] indexAndFound = value == null ? OsSet.nativeRemoveNull(this.nativePtr) : OsSet.nativeRemoveUUID(this.nativePtr, value.toString());
        return indexAndFound[1] == 1L;
    }

    public boolean containsRow(long rowPtr) {
        return OsSet.nativeContainsRow(this.nativePtr, rowPtr);
    }

    public boolean addRow(long rowPtr) {
        long[] indexAndFound = OsSet.nativeAddRow(this.nativePtr, rowPtr);
        return indexAndFound[1] != 0L;
    }

    public boolean removeRow(long rowPtr) {
        long[] indexAndFound = OsSet.nativeRemoveRow(this.nativePtr, rowPtr);
        return indexAndFound[1] != 0L;
    }

    public long getRow(int index) {
        return OsSet.nativeGetRow(this.nativePtr, index);
    }

    public boolean containsRealmAny(long realmAnyPtr) {
        return OsSet.nativeContainsRealmAny(this.nativePtr, realmAnyPtr);
    }

    public boolean addRealmAny(long realmAnyPtr) {
        long[] indexAndFound = OsSet.nativeAddRealmAny(this.nativePtr, realmAnyPtr);
        return indexAndFound[1] != 0L;
    }

    public boolean removeRealmAny(long realmAnyPtr) {
        long[] indexAndFound = OsSet.nativeRemoveRealmAny(this.nativePtr, realmAnyPtr);
        return indexAndFound[1] != 0L;
    }

    public long getRealmAny(int index) {
        return OsSet.nativeGetRealmAny(this.nativePtr, index);
    }

    public boolean containsAll(OsSet otherRealmSet) {
        return OsSet.nativeContainsAll(this.nativePtr, otherRealmSet.getNativePtr());
    }

    public boolean union(OsSet otherRealmSet) {
        return OsSet.nativeUnion(this.nativePtr, otherRealmSet.getNativePtr());
    }

    public boolean asymmetricDifference(OsSet otherSet) {
        return OsSet.nativeAsymmetricDifference(this.nativePtr, otherSet.getNativePtr());
    }

    public boolean intersect(OsSet otherSet) {
        return OsSet.nativeIntersect(this.nativePtr, otherSet.getNativePtr());
    }

    public void clear() {
        OsSet.nativeClear(this.nativePtr);
    }

    public OsSet freeze(OsSharedRealm frozenSharedRealm) {
        long frozenNativePtr = OsSet.nativeFreeze(this.nativePtr, frozenSharedRealm.getNativePtr());
        return new OsSet(frozenSharedRealm, frozenNativePtr, this.targetTable);
    }

    public void startListening(ObservableSet observableSet) {
        OsSet.nativeStartListening(this.nativePtr, observableSet);
    }

    public void stopListening() {
        OsSet.nativeStopListening(this.nativePtr);
    }

    public <T> void notifyChangeListeners(long nativeChangeSetPtr, ObserverPairList<ObservableSet.SetObserverPair<T>> setObserverPairs) {
        OsCollectionChangeSet collectionChangeSet = new OsCollectionChangeSet(nativeChangeSetPtr, false);
        SetChangeSet setChangeSet = new SetChangeSet(collectionChangeSet);
        if (setChangeSet.isEmpty()) {
            return;
        }
        setObserverPairs.foreach(new ObservableSet.Callback(setChangeSet));
    }

    private boolean retainAllInternal(NativeRealmAnyCollection collection) {
        if (this.size() == 0L) {
            return false;
        }
        if (collection.getSize() == 0) {
            this.clear();
            return true;
        }
        return OsSet.nativeRetainAllRealmAnyCollection(this.nativePtr, collection.getNativePtr());
    }

    private static native long nativeGetFinalizerPtr();

    private static native long[] nativeCreate(long var0, long var2, long var4);

    private static native boolean nativeIsValid(long var0);

    private static native long nativeGetQuery(long var0);

    private static native void nativeDeleteAll(long var0);

    private static native Object nativeGetValueAtIndex(long var0, int var2);

    private static native long nativeSize(long var0);

    private static native boolean nativeContainsNull(long var0);

    private static native boolean nativeContainsBoolean(long var0, boolean var2);

    private static native boolean nativeContainsString(long var0, String var2);

    private static native boolean nativeContainsLong(long var0, long var2);

    private static native boolean nativeContainsFloat(long var0, float var2);

    private static native boolean nativeContainsDouble(long var0, double var2);

    private static native boolean nativeContainsBinary(long var0, byte[] var2);

    private static native boolean nativeContainsDate(long var0, long var2);

    private static native boolean nativeContainsDecimal128(long var0, long var2, long var4);

    private static native boolean nativeContainsObjectId(long var0, String var2);

    private static native boolean nativeContainsUUID(long var0, String var2);

    private static native boolean nativeContainsRow(long var0, long var2);

    private static native boolean nativeContainsRealmAny(long var0, long var2);

    private static native long[] nativeAddNull(long var0);

    private static native long[] nativeAddBoolean(long var0, boolean var2);

    private static native long[] nativeAddString(long var0, String var2);

    private static native long[] nativeAddLong(long var0, long var2);

    private static native long[] nativeAddFloat(long var0, float var2);

    private static native long[] nativeAddDouble(long var0, double var2);

    private static native long[] nativeAddBinary(long var0, byte[] var2);

    private static native long[] nativeAddDate(long var0, long var2);

    private static native long[] nativeAddDecimal128(long var0, long var2, long var4);

    private static native long[] nativeAddObjectId(long var0, String var2);

    private static native long[] nativeAddUUID(long var0, String var2);

    private static native long[] nativeAddRow(long var0, long var2);

    private static native long[] nativeAddRealmAny(long var0, long var2);

    private static native long[] nativeRemoveNull(long var0);

    private static native long[] nativeRemoveBoolean(long var0, boolean var2);

    private static native long[] nativeRemoveString(long var0, String var2);

    private static native long[] nativeRemoveLong(long var0, long var2);

    private static native long[] nativeRemoveFloat(long var0, float var2);

    private static native long[] nativeRemoveDouble(long var0, double var2);

    private static native long[] nativeRemoveBinary(long var0, byte[] var2);

    private static native long[] nativeRemoveDate(long var0, long var2);

    private static native long[] nativeRemoveDecimal128(long var0, long var2, long var4);

    private static native long[] nativeRemoveObjectId(long var0, String var2);

    private static native long[] nativeRemoveUUID(long var0, String var2);

    private static native long[] nativeRemoveRow(long var0, long var2);

    private static native long[] nativeRemoveRealmAny(long var0, long var2);

    private static native long nativeGetRow(long var0, int var2);

    private static native long nativeGetRealmAny(long var0, int var2);

    private static native boolean nativeContainsAllRealmAnyCollection(long var0, long var2);

    private static native boolean nativeContainsAll(long var0, long var2);

    private static native boolean nativeUnion(long var0, long var2);

    private static native boolean nativeAddAllRealmAnyCollection(long var0, long var2);

    private static native boolean nativeAsymmetricDifference(long var0, long var2);

    private static native boolean nativeRemoveAllRealmAnyCollection(long var0, long var2);

    private static native boolean nativeIntersect(long var0, long var2);

    private static native boolean nativeRetainAllRealmAnyCollection(long var0, long var2);

    private static native void nativeClear(long var0);

    private static native long nativeFreeze(long var0, long var2);

    private static native void nativeStartListening(long var0, ObservableSet var2);

    private static native void nativeStopListening(long var0);

    public static enum ExternalCollectionOperation {
        CONTAINS_ALL,
        ADD_ALL,
        REMOVE_ALL,
        RETAIN_ALL;

    }
}

