/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http;

import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedObserver;
import rx.observers.Subscribers;
import rx.schedulers.Schedulers;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

public final class UnicastContentSubject<T>
extends Subject<T, T> {
    private final State<T> state;
    private volatile Observable<Long> timeoutScheduler;

    private UnicastContentSubject(State<T> state) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.empty();
    }

    private UnicastContentSubject(State<T> state, long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler scheduler) {
        super(new OnSubscribeAction<T>(state));
        this.state = state;
        this.timeoutScheduler = Observable.interval((long)noSubscriptionTimeout, (TimeUnit)timeUnit, (Scheduler)scheduler).take(1);
    }

    public static <T> UnicastContentSubject<T> createWithoutNoSubscriptionTimeout(Action0 onUnsubscribe) {
        State state = new State(onUnsubscribe);
        return new UnicastContentSubject(state);
    }

    public static <T> UnicastContentSubject<T> createWithoutNoSubscriptionTimeout() {
        return UnicastContentSubject.createWithoutNoSubscriptionTimeout(null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, (Action0)null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Action0 onUnsubscribe) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, Schedulers.computation(), onUnsubscribe);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler) {
        return UnicastContentSubject.create(noSubscriptionTimeout, timeUnit, timeoutScheduler, null);
    }

    public static <T> UnicastContentSubject<T> create(long noSubscriptionTimeout, TimeUnit timeUnit, Scheduler timeoutScheduler, Action0 onUnsubscribe) {
        State state = new State(onUnsubscribe);
        return new UnicastContentSubject(state, noSubscriptionTimeout, timeUnit, timeoutScheduler);
    }

    public boolean disposeIfNotSubscribed() {
        if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.DISPOSED)) {
            PassThruObserver<T> noOpSub = new PassThruObserver<T>(Subscribers.empty(), this.state);
            ((State)this.state).buffer.sendAllNotifications(noOpSub);
            this.state.setObserverRef((Observer<T>)noOpSub);
            if (null != ((State)this.state).onUnsubscribe) {
                ((State)this.state).onUnsubscribe.call();
            }
            return true;
        }
        return false;
    }

    public void updateTimeoutIfNotScheduled(long noSubscriptionTimeout, TimeUnit timeUnit) {
        if (0 == ((State)this.state).timeoutScheduled) {
            this.timeoutScheduler = Observable.interval((long)noSubscriptionTimeout, (TimeUnit)timeUnit).take(1);
        }
    }

    public void onCompleted() {
        ((State)this.state).observerRef.onCompleted();
    }

    public void onError(Throwable e) {
        ((State)this.state).observerRef.onError(e);
    }

    public void onNext(T t) {
        ((State)this.state).observerRef.onNext(t);
        if (this.state.casTimeoutScheduled()) {
            this.timeoutScheduler.subscribe((Action1)new Action1<Long>(){

                public void call(Long aLong) {
                    UnicastContentSubject.this.disposeIfNotSubscribed();
                }
            });
        }
    }

    public boolean hasObservers() {
        return ((State)this.state).observerRef != null;
    }

    private static final class ByteBufAwareBuffer<T> {
        private final ConcurrentLinkedQueue<Object> actual = new ConcurrentLinkedQueue();
        private final NotificationLite<T> nl = NotificationLite.instance();

        private ByteBufAwareBuffer() {
        }

        private void add(Object toAdd) {
            ReferenceCountUtil.retain((Object)toAdd);
            this.actual.add(toAdd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendAllNotifications(Subscriber<? super T> subscriber) {
            Object notification;
            while ((notification = this.actual.poll()) != null) {
                try {
                    this.nl.accept(subscriber, notification);
                }
                finally {
                    ReferenceCountUtil.release((Object)notification);
                }
            }
        }
    }

    private static final class PassThruObserver<T>
    extends Subscriber<T> {
        private final Observer<? super T> actual;
        private final ByteBufAwareBuffer<T> buffer;
        private final State<T> state;
        private volatile boolean draining;

        PassThruObserver(Observer<? super T> actual, State<T> state) {
            this.actual = actual;
            this.buffer = ((State)state).buffer;
            this.state = state;
        }

        public void onCompleted() {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onCompleted();
        }

        public void onError(Throwable e) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onError(e);
        }

        public void onNext(T t) {
            this.drainIfNeededAndSwitchToActual();
            this.actual.onNext(t);
        }

        private void drainIfNeededAndSwitchToActual() {
            if (this.draining) {
                return;
            }
            this.draining = true;
            this.buffer.sendAllNotifications(this);
            this.state.casObserverRef((Observer<? super T>)this, this.actual);
        }
    }

    private static final class OnSubscribeAction<T>
    implements Observable.OnSubscribe<T> {
        private final State<T> state;

        public OnSubscribeAction(State<T> state) {
            this.state = state;
        }

        public void call(Subscriber<? super T> subscriber) {
            if (this.state.casState(State.STATES.UNSUBSCRIBED, State.STATES.SUBSCRIBED)) {
                ((State)this.state).buffer.sendAllNotifications(subscriber);
                this.state.setObserverRef((Observer<? super T>)new PassThruObserver<T>(subscriber, this.state));
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        if (null != OnSubscribeAction.this.state.onUnsubscribe) {
                            OnSubscribeAction.this.state.onUnsubscribe.call();
                        }
                        OnSubscribeAction.this.state.setObserverRef(Subscribers.empty());
                    }
                }));
            } else if (State.STATES.SUBSCRIBED.ordinal() == ((State)this.state).state) {
                subscriber.onError((Throwable)new IllegalStateException("Content can only have one subscription. Use Observable.publish() if you want to multicast."));
            } else if (State.STATES.DISPOSED.ordinal() == ((State)this.state).state) {
                subscriber.onError((Throwable)new IllegalStateException("Content stream is already disposed."));
            }
        }
    }

    private static final class State<T> {
        private final Action0 onUnsubscribe;
        private volatile int state = STATES.UNSUBSCRIBED.ordinal();
        private volatile Observer<? super T> observerRef = new BufferedObserver();
        private volatile int timeoutScheduled;
        private final ByteBufAwareBuffer<T> buffer = new ByteBufAwareBuffer();
        private static final AtomicReferenceFieldUpdater<State, Observer> OBSERVER_UPDATER = AtomicReferenceFieldUpdater.newUpdater(State.class, Observer.class, "observerRef");
        private static final AtomicIntegerFieldUpdater<State> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "state");
        private static final AtomicIntegerFieldUpdater<State> TIMEOUT_SCHEDULED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(State.class, "timeoutScheduled");

        public State() {
            this(null);
        }

        public State(Action0 onUnsubscribe) {
            this.onUnsubscribe = onUnsubscribe;
        }

        public boolean casState(STATES expected, STATES next) {
            return STATE_UPDATER.compareAndSet(this, expected.ordinal(), next.ordinal());
        }

        public void setObserverRef(Observer<? super T> o) {
            this.observerRef = new SerializedObserver(o);
        }

        public boolean casObserverRef(Observer<? super T> expected, Observer<? super T> next) {
            return OBSERVER_UPDATER.compareAndSet(this, expected, next);
        }

        public boolean casTimeoutScheduled() {
            return TIMEOUT_SCHEDULED_UPDATER.compareAndSet(this, 0, 1);
        }

        private final class BufferedObserver
        extends Subscriber<T> {
            private final NotificationLite<Object> nl = NotificationLite.instance();

            private BufferedObserver() {
            }

            public void onCompleted() {
                State.this.buffer.add(this.nl.completed());
            }

            public void onError(Throwable e) {
                State.this.buffer.add(this.nl.error(e));
            }

            public void onNext(T t) {
                State.this.buffer.add(this.nl.next(t));
            }
        }

        private static enum STATES {
            UNSUBSCRIBED,
            SUBSCRIBED,
            DISPOSED;

        }
    }
}

