/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.servo.http.websocket;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.LongGauge;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Timer;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.WebSocketClientMetricEventsListener;
import io.reactivex.netty.protocol.http.websocket.WebSocketClientMetricsEvent;
import io.reactivex.netty.servo.ServoUtils;
import io.reactivex.netty.servo.tcp.TcpClientListener;
import java.util.concurrent.TimeUnit;

public class WebSocketClientListener
extends TcpClientListener<ClientMetricsEvent<?>> {
    private final LongGauge inflightHandshakes;
    private final LongGauge processedHandshakes;
    private final LongGauge failedHandshakes;
    private final Counter webSocketWrites;
    private final Counter getWebSocketReads;
    private final Timer handshakeProcessingTimes;
    private final WebSocketClientMetricEventsListenerImpl delegate = new WebSocketClientMetricEventsListenerImpl();

    protected WebSocketClientListener(String monitorId) {
        super(monitorId);
        this.inflightHandshakes = ServoUtils.newLongGauge("inflightHandshakes");
        this.processedHandshakes = ServoUtils.newLongGauge("processedHandshakes");
        this.failedHandshakes = ServoUtils.newLongGauge("failedHandshakes");
        this.webSocketWrites = Monitors.newCounter((String)"webSocketWrites");
        this.getWebSocketReads = Monitors.newCounter((String)"getWebSocketReads");
        this.handshakeProcessingTimes = Monitors.newTimer((String)"handshakeProcessingTimes");
    }

    public static WebSocketClientListener newWebSocketListener(String monitorId) {
        return new WebSocketClientListener(monitorId);
    }

    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType().getClass() == WebSocketClientMetricsEvent.EventType.class) {
            this.delegate.onEvent(event, duration, timeUnit, throwable, value);
        } else {
            super.onEvent(event, duration, timeUnit, throwable, value);
        }
    }

    public long getInflightHandshakes() {
        return this.inflightHandshakes.getNumber().get();
    }

    public long getProcessedHandshakes() {
        return this.processedHandshakes.getNumber().get();
    }

    public long getFailedHandshakes() {
        return ((Number)this.failedHandshakes.getValue()).longValue();
    }

    public Timer getHandshakeProcessingTimes() {
        return this.handshakeProcessingTimes;
    }

    public long getWebSocketWrites() {
        return ((Number)this.webSocketWrites.getValue()).longValue();
    }

    public long getWebSocketReads() {
        return ((Number)this.getWebSocketReads.getValue()).longValue();
    }

    private class WebSocketClientMetricEventsListenerImpl
    extends WebSocketClientMetricEventsListener {
        private WebSocketClientMetricEventsListenerImpl() {
        }

        protected void onHandshakeStart() {
            ServoUtils.incrementLongGauge(WebSocketClientListener.this.inflightHandshakes);
        }

        protected void onHandshakeSuccess(long duration, TimeUnit timeUnit) {
            ServoUtils.decrementLongGauge(WebSocketClientListener.this.inflightHandshakes);
            ServoUtils.incrementLongGauge(WebSocketClientListener.this.processedHandshakes);
            WebSocketClientListener.this.handshakeProcessingTimes.record(duration, timeUnit);
        }

        protected void onHandshakeFailure(long duration, TimeUnit timeUnit, Throwable throwable) {
            ServoUtils.decrementLongGauge(WebSocketClientListener.this.inflightHandshakes);
            ServoUtils.incrementLongGauge(WebSocketClientListener.this.processedHandshakes);
            ServoUtils.incrementLongGauge(WebSocketClientListener.this.failedHandshakes);
            WebSocketClientListener.this.handshakeProcessingTimes.record(duration, timeUnit);
        }

        protected void onWebSocketWrites() {
            WebSocketClientListener.this.webSocketWrites.increment();
        }

        protected void onWebSocketReads() {
            WebSocketClientListener.this.getWebSocketReads.increment();
        }
    }
}

