/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts.http;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.reactivex.netty.contexts.AbstractServerContextHandler;
import io.reactivex.netty.contexts.ContextKeySupplier;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import io.reactivex.netty.contexts.http.HttpContextKeySupplier;

@ChannelHandler.Sharable
public class HttpServerContextHandler
extends AbstractServerContextHandler<HttpRequest, HttpResponse> {
    private String currentlyProcessingRequestId;

    public HttpServerContextHandler(RequestIdProvider requestIdProvider, RequestCorrelator correlator) {
        super(correlator, requestIdProvider);
        if (null == requestIdProvider) {
            throw new IllegalArgumentException("Request Id Provider can not be null.");
        }
        if (null == correlator) {
            throw new IllegalArgumentException("Request correlator can not be null.");
        }
    }

    @Override
    protected boolean isAcceptableToRead(Object msg) {
        return msg instanceof HttpRequest;
    }

    @Override
    protected boolean isAcceptableToWrite(Object msg) {
        return msg instanceof HttpResponse;
    }

    @Override
    protected void addKey(HttpResponse response, String key, String value) {
        response.headers().add(key, (Object)value);
    }

    @Override
    protected ContextKeySupplier newKeySupplierForWrite(HttpResponse msg) {
        return new HttpContextKeySupplier(msg.headers());
    }

    @Override
    protected ContextKeySupplier newKeySupplierForRead(HttpRequest msg) {
        return new HttpContextKeySupplier(msg.headers());
    }

    @Override
    protected void newRequestIdWritten(String requestId) {
        this.currentlyProcessingRequestId = requestId;
    }

    @Override
    protected String getCurrentlyProcessingRequestId() {
        return this.currentlyProcessingRequestId;
    }

    @Override
    protected boolean isLastResponseFragmenTotWrite(Object response) {
        return response instanceof LastHttpContent;
    }
}

