/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableUsing<R>
extends Completable {
    final Supplier<R> resourceSupplier;
    final Function<? super R, ? extends CompletableSource> completableFunction;
    final Consumer<? super R> disposer;
    final boolean eager;

    public CompletableUsing(Supplier<R> resourceSupplier, Function<? super R, ? extends CompletableSource> completableFunction, Consumer<? super R> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.completableFunction = completableFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        CompletableSource source;
        R resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.completableFunction.apply(resource), "The completableFunction returned a null CompletableSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex, observer);
            if (!this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new UsingObserver<R>(observer, resource, this.disposer, this.eager));
    }

    static final class UsingObserver<R>
    extends AtomicReference<Object>
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = -674404550052917487L;
        final CompletableObserver downstream;
        final Consumer<? super R> disposer;
        final boolean eager;
        Disposable upstream;

        UsingObserver(CompletableObserver actual, R resource, Consumer<? super R> disposer, boolean eager) {
            super(resource);
            this.downstream = actual;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(e, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onComplete();
            if (!this.eager) {
                this.disposeResource();
            }
        }
    }
}

