/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTake<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long limit;

    public FlowableTake(Flowable<T> source, long limit) {
        super(source);
        this.limit = limit;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new TakeSubscriber<T>(s, this.limit));
    }

    static final class TakeSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5636543848937116287L;
        final Subscriber<? super T> downstream;
        final long limit;
        boolean done;
        Subscription upstream;
        long remaining;

        TakeSubscriber(Subscriber<? super T> actual, long limit) {
            this.downstream = actual;
            this.limit = limit;
            this.remaining = limit;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (this.limit == 0L) {
                    s.cancel();
                    this.done = true;
                    EmptySubscription.complete(this.downstream);
                } else {
                    this.downstream.onSubscribe((Subscription)this);
                }
            }
        }

        public void onNext(T t) {
            if (!this.done && this.remaining-- > 0L) {
                boolean stop = this.remaining == 0L;
                this.downstream.onNext(t);
                if (stop) {
                    this.upstream.cancel();
                    this.onComplete();
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.done) {
                this.done = true;
                this.upstream.cancel();
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            if (!this.get() && this.compareAndSet(false, true) && n >= this.limit) {
                this.upstream.request(Long.MAX_VALUE);
                return;
            }
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }
}

