/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends Subject<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Observer<? super T>> actual;
    final AtomicReference<Runnable> onTerminate;
    final boolean delayError;
    volatile boolean disposed;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean once;
    final BasicIntQueueDisposable<T> wip;
    boolean enableOperatorFusion;

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create() {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint) {
        return new UnicastSubject<T>(capacityHint, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onTerminate) {
        return new UnicastSubject<T>(capacityHint, onTerminate, true);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onTerminate, boolean delayError) {
        return new UnicastSubject<T>(capacityHint, onTerminate, delayError);
    }

    @CheckReturnValue
    @NonNull
    public static <T> UnicastSubject<T> create(boolean delayError) {
        return new UnicastSubject<T>(UnicastSubject.bufferSize(), delayError);
    }

    UnicastSubject(int capacityHint, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference();
        this.delayError = delayError;
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueDisposable();
    }

    UnicastSubject(int capacityHint, Runnable onTerminate) {
        this(capacityHint, onTerminate, true);
    }

    UnicastSubject(int capacityHint, Runnable onTerminate, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference<Runnable>(ObjectHelper.requireNonNull(onTerminate, "onTerminate"));
        this.delayError = delayError;
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueDisposable();
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            observer.onSubscribe(this.wip);
            this.actual.lazySet(observer);
            if (this.disposed) {
                this.actual.lazySet(null);
                return;
            }
            this.drain();
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only a single observer allowed."), observer);
        }
    }

    void doTerminate() {
        Runnable r = this.onTerminate.get();
        if (r != null && this.onTerminate.compareAndSet(r, null)) {
            r.run();
        }
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (this.done || this.disposed) {
            s.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.disposed) {
            return;
        }
        this.queue.offer(t);
        this.drain();
    }

    @Override
    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done || this.disposed) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.error = t;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.disposed) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    void drainNormal(Observer<? super T> a) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        boolean failFast = !this.delayError;
        boolean canBeError = true;
        while (true) {
            boolean empty;
            if (this.disposed) {
                this.actual.lazySet(null);
                q.clear();
                return;
            }
            boolean d = this.done;
            T v = this.queue.poll();
            boolean bl = empty = v == null;
            if (d) {
                if (failFast && canBeError) {
                    if (this.failedFast(q, a)) {
                        return;
                    }
                    canBeError = false;
                }
                if (empty) {
                    this.errorOrComplete(a);
                    return;
                }
            }
            if (!empty) {
                a.onNext(v);
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    void drainFused(Observer<? super T> a) {
        boolean failFast;
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        boolean bl = failFast = !this.delayError;
        do {
            if (this.disposed) {
                this.actual.lazySet(null);
                q.clear();
                return;
            }
            boolean d = this.done;
            if (failFast && d && this.failedFast(q, a)) {
                return;
            }
            a.onNext(null);
            if (!d) continue;
            this.errorOrComplete(a);
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void errorOrComplete(Observer<? super T> a) {
        this.actual.lazySet(null);
        Throwable ex = this.error;
        if (ex != null) {
            a.onError(ex);
        } else {
            a.onComplete();
        }
    }

    boolean failedFast(SimpleQueue<T> q, Observer<? super T> a) {
        Throwable ex = this.error;
        if (ex != null) {
            this.actual.lazySet(null);
            q.clear();
            a.onError(ex);
            return true;
        }
        return false;
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Observer<? super T> a = this.actual.get();
        int missed = 1;
        while (true) {
            if (a != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a);
                } else {
                    this.drainNormal(a);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a = this.actual.get();
        }
    }

    @Override
    public boolean hasObservers() {
        return this.actual.get() != null;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    final class UnicastQueueDisposable
    extends BasicIntQueueDisposable<T> {
        private static final long serialVersionUID = 7926949470189395511L;

        UnicastQueueDisposable() {
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                UnicastSubject.this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            return UnicastSubject.this.queue.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastSubject.this.queue.isEmpty();
        }

        @Override
        public void clear() {
            UnicastSubject.this.queue.clear();
        }

        @Override
        public void dispose() {
            if (!UnicastSubject.this.disposed) {
                UnicastSubject.this.disposed = true;
                UnicastSubject.this.doTerminate();
                UnicastSubject.this.actual.lazySet(null);
                if (UnicastSubject.this.wip.getAndIncrement() == 0) {
                    UnicastSubject.this.actual.lazySet(null);
                    UnicastSubject.this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return UnicastSubject.this.disposed;
        }
    }
}

