/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;

public final class MaybeOnErrorReturn<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public MaybeOnErrorReturn(MaybeSource<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new OnErrorReturnMaybeObserver<T>(observer, this.valueSupplier));
    }

    static final class OnErrorReturnMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        final Function<? super Throwable, ? extends T> valueSupplier;
        Disposable d;

        OnErrorReturnMaybeObserver(MaybeObserver<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            this.actual = actual;
            this.valueSupplier = valueSupplier;
        }

        @Override
        public void dispose() {
            this.d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            T v;
            try {
                v = ObjectHelper.requireNonNull(this.valueSupplier.apply(e), "The valueSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(new CompositeException(e, ex));
                return;
            }
            this.actual.onSuccess(v);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }
    }
}

