/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.observers.BasicFuseableObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableFilter<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableFilter(ObservableSource<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new FilterObserver<T>(s, this.predicate));
    }

    static final class FilterObserver<T>
    extends BasicFuseableObserver<T, T> {
        final Predicate<? super T> filter;
        Disposable s;

        FilterObserver(Observer<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 0) {
                boolean b;
                try {
                    b = this.filter.test(t);
                }
                catch (Throwable e) {
                    this.fail(e);
                    return;
                }
                if (b) {
                    this.actual.onNext(t);
                }
            } else {
                this.actual.onNext(null);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public T poll() throws Exception {
            Object v;
            while ((v = this.qs.poll()) != null && !this.filter.test(v)) {
            }
            return v;
        }
    }
}

