/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.util.LinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableCache<T>
extends AbstractObservableWithUpstream<T, T> {
    final CacheState<T> state;
    final AtomicBoolean once;

    public static <T> Observable<T> from(Observable<T> source) {
        return ObservableCache.from(source, 16);
    }

    public static <T> Observable<T> from(Observable<T> source, int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        CacheState<T> state = new CacheState<T>(source, capacityHint);
        return RxJavaPlugins.onAssembly(new ObservableCache<T>(source, state));
    }

    private ObservableCache(Observable<T> source, CacheState<T> state) {
        super(source);
        this.state = state;
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(Observer<? super T> t) {
        ReplayDisposable<T> rp = new ReplayDisposable<T>(t, this.state);
        this.state.addChild(rp);
        t.onSubscribe(rp);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
        rp.replay();
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasObservers() {
        return this.state.observers.length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }

    static final class ReplayDisposable<T>
    implements Disposable {
        final Observer<? super T> child;
        final CacheState<T> state;
        Object[] currentBuffer;
        int currentIndexInBuffer;
        int index;
        boolean emitting;
        boolean missed;
        volatile boolean cancelled;

        ReplayDisposable(Observer<? super T> child, CacheState<T> state) {
            this.child = child;
            this.state = state;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.removeChild(this);
            }
        }

        /*
         * Exception decompiling
         */
        public void replay() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [39[UNCONDITIONALDOLOOP]], but top level block is 21[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class CacheState<T>
    extends LinkedArrayList
    implements Observer<T> {
        final Observable<? extends T> source;
        final SequentialDisposable connection;
        volatile ReplayDisposable<?>[] observers;
        static final ReplayDisposable<?>[] EMPTY = new ReplayDisposable[0];
        volatile boolean isConnected;
        boolean sourceDone;

        CacheState(Observable<? extends T> source, int capacityHint) {
            super(capacityHint);
            this.source = source;
            this.observers = EMPTY;
            this.connection = new SequentialDisposable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChild(ReplayDisposable<T> p) {
            SequentialDisposable sequentialDisposable = this.connection;
            synchronized (sequentialDisposable) {
                ReplayDisposable<?>[] a = this.observers;
                int n = a.length;
                ReplayDisposable[] b = new ReplayDisposable[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = p;
                this.observers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChild(ReplayDisposable<T> p) {
            SequentialDisposable sequentialDisposable = this.connection;
            synchronized (sequentialDisposable) {
                ReplayDisposable<?>[] a = this.observers;
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!a[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    this.observers = EMPTY;
                    return;
                }
                ReplayDisposable[] b = new ReplayDisposable[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
                this.observers = b;
            }
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.connection.update(s);
        }

        public void connect() {
            this.source.subscribe(this);
            this.isConnected = true;
        }

        @Override
        public void onNext(T t) {
            if (!this.sourceDone) {
                Object o = NotificationLite.next(t);
                this.add(o);
                this.dispatch();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.error(e);
                this.add(o);
                this.connection.dispose();
                this.dispatch();
            }
        }

        @Override
        public void onComplete() {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.complete();
                this.add(o);
                this.connection.dispose();
                this.dispatch();
            }
        }

        void dispatch() {
            ReplayDisposable<?>[] a;
            for (ReplayDisposable<?> rp : a = this.observers) {
                rp.replay();
            }
        }
    }
}

