/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.Notification;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class TestSubscriber<T>
implements Subscriber<T>,
Subscription,
Disposable {
    private final Subscriber<? super T> actual;
    private final CountDownLatch done;
    private final List<T> values;
    private final List<Throwable> errors;
    private long completions;
    private Thread lastThread;
    private volatile boolean cancelled;
    private final AtomicReference<Subscription> subscription;
    private final AtomicLong missedRequested;
    private boolean checkSubscriptionOnce;
    private int initialFusionMode;
    private int establishedFusionMode;
    private QueueSubscription<T> qs;

    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    public static <T> TestSubscriber<T> create(long initialRequested) {
        return new TestSubscriber<T>(initialRequested);
    }

    public static <T> TestSubscriber<T> create(Subscriber<? super T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    public TestSubscriber() {
        this(EmptySubscriber.INSTANCE, Long.MAX_VALUE);
    }

    public TestSubscriber(long initialRequest) {
        this(EmptySubscriber.INSTANCE, initialRequest);
    }

    public TestSubscriber(Subscriber<? super T> actual) {
        this(actual, Long.MAX_VALUE);
    }

    public TestSubscriber(Subscriber<? super T> actual, long initialRequest) {
        this.actual = actual;
        this.values = new ArrayList<T>();
        this.errors = new ArrayList<Throwable>();
        this.done = new CountDownLatch(1);
        this.subscription = new AtomicReference();
        this.missedRequested = new AtomicLong(initialRequest);
    }

    public void onSubscribe(Subscription s) {
        this.lastThread = Thread.currentThread();
        if (s == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.subscription.compareAndSet(null, s)) {
            s.cancel();
            if (this.subscription.get() != SubscriptionHelper.CANCELLED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + s));
            }
            return;
        }
        if (this.initialFusionMode != 0 && s instanceof QueueSubscription) {
            int m;
            this.qs = (QueueSubscription)s;
            this.establishedFusionMode = m = this.qs.requestFusion(this.initialFusionMode);
            if (m == 1) {
                this.checkSubscriptionOnce = true;
                this.lastThread = Thread.currentThread();
                try {
                    Object t;
                    while ((t = this.qs.poll()) != null) {
                        this.values.add(t);
                    }
                    ++this.completions;
                }
                catch (Throwable ex) {
                    this.errors.add(ex);
                }
                return;
            }
        }
        this.actual.onSubscribe(s);
        long mr = this.missedRequested.getAndSet(0L);
        if (mr != 0L) {
            s.request(mr);
        }
        this.onStart();
    }

    protected void onStart() {
    }

    public void onNext(T t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        if (this.establishedFusionMode == 2) {
            try {
                while ((t = this.qs.poll()) != null) {
                    this.values.add(t);
                }
            }
            catch (Throwable ex) {
                this.errors.add(ex);
            }
            return;
        }
        this.values.add(t);
        if (t == null) {
            this.errors.add(new NullPointerException("onNext received a null Subscription"));
        }
        this.actual.onNext(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new NullPointerException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            this.errors.add(t);
            if (t == null) {
                this.errors.add(new IllegalStateException("onError received a null Subscription"));
            }
            this.actual.onError(t);
        }
        finally {
            this.done.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.subscription.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.actual.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    public final void request(long n) {
        SubscriptionHelper.deferredRequest(this.subscription, this.missedRequested, n);
    }

    public final void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.subscription);
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final void dispose() {
        this.cancel();
    }

    @Override
    public final boolean isDisposed() {
        return this.cancelled;
    }

    public final Thread lastThread() {
        return this.lastThread;
    }

    public final List<T> values() {
        return this.values;
    }

    public final List<Throwable> errors() {
        return this.errors;
    }

    public final long completions() {
        return this.completions;
    }

    public final boolean isTerminated() {
        return this.done.getCount() == 0L;
    }

    public final int valueCount() {
        return this.values.size();
    }

    public final int errorCount() {
        return this.errors.size();
    }

    public final boolean hasSubscription() {
        return this.subscription.get() != null;
    }

    public final TestSubscriber<T> await() throws InterruptedException {
        if (this.done.getCount() == 0L) {
            return this;
        }
        this.done.await();
        return this;
    }

    private AssertionError fail(String message) {
        StringBuilder b = new StringBuilder(64 + message.length());
        b.append(message);
        b.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions).append(')');
        AssertionError ae = new AssertionError((Object)b.toString());
        CompositeException ce = new CompositeException();
        for (Throwable e : this.errors) {
            if (e == null) {
                ce.suppress(new NullPointerException("Throwable was null!"));
                continue;
            }
            ce.suppress(e);
        }
        if (!ce.isEmpty()) {
            ((Throwable)((Object)ae)).initCause(ce);
        }
        return ae;
    }

    public final TestSubscriber<T> assertComplete() {
        long c = this.completions;
        if (c == 0L) {
            throw this.fail("Not completed");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return this;
    }

    public final TestSubscriber<T> assertNotComplete() {
        long c = this.completions;
        if (c == 1L) {
            throw this.fail("Completed!");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return this;
    }

    public final TestSubscriber<T> assertNoErrors() {
        int s = this.errors.size();
        if (s != 0) {
            throw this.fail("Error(s) present: " + this.errors);
        }
        return this;
    }

    public final TestSubscriber<T> assertError(Throwable error) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        if (this.errors.contains(error)) {
            if (s != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return this;
    }

    public final TestSubscriber<T> assertError(Class<? extends Throwable> errorClass) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            if (!errorClass.isInstance(e)) continue;
            found = true;
            break;
        }
        if (found) {
            if (s != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return this;
    }

    public final TestSubscriber<T> assertError(Predicate<Throwable> errorPredicate) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            try {
                if (!errorPredicate.test(e)) continue;
                found = true;
                break;
            }
            catch (Exception ex) {
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if (found) {
            if (s != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return this;
    }

    public final TestSubscriber<T> assertValue(T value) {
        int s = this.values.size();
        if (s != 1) {
            throw this.fail("Expected: " + TestSubscriber.valueAndClass(value) + ", Actual: " + this.values);
        }
        T v = this.values.get(0);
        if (!ObjectHelper.equals(value, v)) {
            throw this.fail("Expected: " + TestSubscriber.valueAndClass(value) + ", Actual: " + TestSubscriber.valueAndClass(v));
        }
        return this;
    }

    static String valueAndClass(Object o) {
        if (o != null) {
            return o + " (class: " + o.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public final TestSubscriber<T> assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            throw this.fail("Value counts differ; Expected: " + count + ", Actual: " + s);
        }
        return this;
    }

    public final TestSubscriber<T> assertNoValues() {
        return this.assertValueCount(0);
    }

    public final TestSubscriber<T> assertValues(T ... values) {
        int s = this.values.size();
        if (s != values.length) {
            throw this.fail("Value count differs; Expected: " + values.length + " " + Arrays.toString(values) + ", Actual: " + s + " " + this.values);
        }
        for (int i = 0; i < s; ++i) {
            T u = values[i];
            T v = this.values.get(i);
            if (ObjectHelper.equals(u, v)) continue;
            throw this.fail("Values at position " + i + " differ; Expected: " + TestSubscriber.valueAndClass(u) + ", Actual: " + TestSubscriber.valueAndClass(v));
        }
        return this;
    }

    public final TestSubscriber<T> assertValueSet(Collection<? extends T> expected) {
        if (expected.isEmpty()) {
            this.assertNoValues();
            return this;
        }
        for (T v : this.values) {
            if (expected.contains(v)) continue;
            throw this.fail("Value not in the expected collection: " + TestSubscriber.valueAndClass(v));
        }
        return this;
    }

    public final TestSubscriber<T> assertValueSequence(Iterable<? extends T> sequence) {
        boolean expectedNext;
        boolean actualNext;
        int i = 0;
        Iterator<T> vit = this.values.iterator();
        Iterator<T> it = sequence.iterator();
        while (true) {
            actualNext = it.hasNext();
            expectedNext = vit.hasNext();
            if (!actualNext || !expectedNext) break;
            T v = it.next();
            T u = vit.next();
            if (!ObjectHelper.equals(u, v)) {
                throw this.fail("Values at position " + i + " differ; Expected: " + TestSubscriber.valueAndClass(u) + ", Actual: " + TestSubscriber.valueAndClass(v));
            }
            ++i;
        }
        if (actualNext) {
            throw this.fail("More values received than expected (" + i + ")");
        }
        if (expectedNext) {
            throw this.fail("Fever values received than expected (" + i + ")");
        }
        return this;
    }

    public final TestSubscriber<T> assertTerminated() {
        if (this.done.getCount() != 0L) {
            throw this.fail("Subscriber still running!");
        }
        long c = this.completions;
        if (c > 1L) {
            throw this.fail("Terminated with multiple completions: " + c);
        }
        int s = this.errors.size();
        if (s > 1) {
            throw this.fail("Terminated with multiple errors: " + s);
        }
        if (c != 0L && s != 0) {
            throw this.fail("Terminated with multiple completions and errors: " + c);
        }
        return this;
    }

    public final TestSubscriber<T> assertNotTerminated() {
        if (this.done.getCount() == 0L) {
            throw this.fail("Subscriber terminated!");
        }
        return this;
    }

    public final TestSubscriber<T> assertSubscribed() {
        if (this.subscription.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    public final TestSubscriber<T> assertNotSubscribed() {
        if (this.subscription.get() != null) {
            throw this.fail("Subscribed!");
        }
        if (!this.errors.isEmpty()) {
            throw this.fail("Not subscribed but errors found");
        }
        return this;
    }

    public final boolean awaitTerminalEvent() {
        try {
            this.await();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitTerminalEvent(long duration, TimeUnit unit) {
        try {
            return this.await(duration, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final TestSubscriber<T> assertErrorMessage(String message) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        if (s == 1) {
            Throwable e = this.errors.get(0);
            String errorMessage = e.getMessage();
            if (!ObjectHelper.equals(message, errorMessage)) {
                throw this.fail("Error message differs; Expected: " + message + ", Actual: " + errorMessage);
            }
        } else {
            throw this.fail("Multiple errors");
        }
        return this;
    }

    public final List<List<Object>> getEvents() {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        result.add(this.values());
        result.add(this.errors());
        ArrayList completeList = new ArrayList();
        for (long i = 0L; i < this.completions; ++i) {
            completeList.add(Notification.createOnComplete());
        }
        result.add(completeList);
        return result;
    }

    final TestSubscriber<T> setInitialFusionMode(int mode) {
        this.initialFusionMode = mode;
        return this;
    }

    final TestSubscriber<T> assertFusionMode(int mode) {
        int m = this.establishedFusionMode;
        if (m != mode) {
            if (this.qs != null) {
                throw new AssertionError((Object)("Fusion mode different. Expected: " + TestSubscriber.fusionModeToString(mode) + ", actual: " + TestSubscriber.fusionModeToString(m)));
            }
            throw this.fail("Upstream is not fuseable");
        }
        return this;
    }

    static String fusionModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "SYNC";
            }
            case 2: {
                return "ASYNC";
            }
        }
        return "Unknown(" + mode + ")";
    }

    final TestSubscriber<T> assertFuseable() {
        if (this.qs == null) {
            throw new AssertionError((Object)"Upstream is not fuseable.");
        }
        return this;
    }

    final TestSubscriber<T> assertNotFuseable() {
        if (this.qs != null) {
            throw new AssertionError((Object)"Upstream is fuseable.");
        }
        return this;
    }

    public final TestSubscriber<T> assertOf(Consumer<? super TestSubscriber<T>> check) {
        try {
            check.accept(this);
        }
        catch (Throwable ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return this;
    }

    public final TestSubscriber<T> assertResult(T ... values) {
        return this.assertSubscribed().assertValues(values).assertNoErrors().assertComplete();
    }

    public final TestSubscriber<T> assertFailure(Class<? extends Throwable> error, T ... values) {
        return this.assertSubscribed().assertValues(values).assertError(error).assertNotComplete();
    }

    public final TestSubscriber<T> assertFailure(Predicate<Throwable> errorPredicate, T ... values) {
        return this.assertSubscribed().assertValues(values).assertError(errorPredicate).assertNotComplete();
    }

    public final TestSubscriber<T> assertFailureAndMessage(Class<? extends Throwable> error, String message, T ... values) {
        return this.assertSubscribed().assertValues(values).assertError(error).assertErrorMessage(message).assertNotComplete();
    }

    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.done.getCount() == 0L || this.done.await(time, unit);
    }

    public final TestSubscriber<T> awaitDone(long time, TimeUnit unit) {
        try {
            if (!this.done.await(time, unit)) {
                this.cancel();
            }
        }
        catch (InterruptedException ex) {
            this.cancel();
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return this;
    }

    public final TestSubscriber<T> assertEmpty() {
        return this.assertSubscribed().assertNoValues().assertNoErrors().assertNotComplete();
    }

    static enum EmptySubscriber implements Subscriber<Object>
    {
        INSTANCE;


        public void onSubscribe(Subscription s) {
        }

        public void onNext(Object t) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }
}

