/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableSingle<T>
extends AbstractObservableWithUpstream<T, T> {
    final T defaultValue;

    public ObservableSingle(ObservableSource<T> source, T defaultValue) {
        super(source);
        this.defaultValue = defaultValue;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new SingleElementObserver<T>(t, this.defaultValue));
    }

    static final class SingleElementObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final T defaultValue;
        Disposable s;
        T value;
        boolean done;

        SingleElementObserver(Observer<? super T> actual, T defaultValue) {
            this.actual = actual;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.s.dispose();
                this.actual.onError(new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            this.value = null;
            if (v == null) {
                v = this.defaultValue;
            }
            if (v != null) {
                this.actual.onNext(v);
            }
            this.actual.onComplete();
        }
    }
}

