/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableObserveOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean delayError;
    final int prefetch;

    public FlowableObserveOn(Publisher<T> source, Scheduler scheduler, boolean delayError, int prefetch) {
        super(source);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Scheduler.Worker worker;
        try {
            worker = this.scheduler.createWorker();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        if (worker == null) {
            EmptySubscription.error(new NullPointerException("The scheduler returned a null Function"), s);
            return;
        }
        if (s instanceof ConditionalSubscriber) {
            ConditionalSubscriber cs = (ConditionalSubscriber)s;
            this.source.subscribe(new PublisherObserveOnConditionalSubscriber(cs, worker, this.delayError, this.prefetch));
            return;
        }
        this.source.subscribe(new PublisherObserveOnSubscriber<T>(s, worker, this.delayError, this.prefetch));
    }

    static final class PublisherObserveOnConditionalSubscriber<T>
    extends BaseObserveOnSubscriber<T> {
        private static final long serialVersionUID = 644624475404284533L;
        final ConditionalSubscriber<? super T> actual;
        long consumed;

        PublisherObserveOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe(this);
                        this.initialRequest();
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.actual.onSubscribe(this);
                this.initialRequest();
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            ConditionalSubscriber a = this.actual;
            SimpleQueue q = this.queue;
            long e = this.produced;
            while (true) {
                int w;
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.doError(a, ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.doComplete(a);
                        return;
                    }
                    if (!a.tryOnNext(v)) continue;
                    ++e;
                }
                if (e == r) {
                    boolean empty;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        empty = q.isEmpty();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.doError(a, ex);
                        return;
                    }
                    if (empty) {
                        this.doComplete(a);
                        return;
                    }
                }
                if (missed == (w = this.get())) {
                    this.produced = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        @Override
        void runAsync() {
            int missed = 1;
            ConditionalSubscriber a = this.actual;
            SimpleQueue q = this.queue;
            long emitted = this.produced;
            long polled = this.consumed;
            while (true) {
                int w;
                boolean d;
                long r = this.requested.get();
                while (emitted != r) {
                    boolean empty;
                    Object v;
                    d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, ex);
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    if (a.tryOnNext(v)) {
                        ++emitted;
                    }
                    if (++polled != (long)this.limit) continue;
                    this.s.request(polled);
                    polled = 0L;
                }
                if (emitted == r) {
                    boolean empty;
                    d = this.done;
                    try {
                        empty = q.isEmpty();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, ex);
                        return;
                    }
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                }
                if (missed == (w = this.get())) {
                    this.produced = emitted;
                    this.consumed = polled;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.actual.onNext(null);
                if (!d) continue;
                Throwable e = this.error;
                if (e != null) {
                    this.doError(this.actual, e);
                } else {
                    this.doComplete(this.actual);
                }
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        public T poll() throws Exception {
            Object v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.consumed + 1L;
                if (p == (long)this.limit) {
                    this.consumed = 0L;
                    this.s.request(p);
                } else {
                    this.consumed = p;
                }
            }
            return v;
        }
    }

    static final class PublisherObserveOnSubscriber<T>
    extends BaseObserveOnSubscriber<T>
    implements Subscriber<T> {
        private static final long serialVersionUID = -4547113800637756442L;
        final Subscriber<? super T> actual;

        PublisherObserveOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe((Subscription)this);
                        this.initialRequest();
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.actual.onSubscribe((Subscription)this);
                this.initialRequest();
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            SimpleQueue q = this.queue;
            long e = this.produced;
            while (true) {
                int w;
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.doError(a, ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.doComplete(a);
                        return;
                    }
                    a.onNext(v);
                    ++e;
                }
                if (e == r) {
                    boolean empty;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        empty = q.isEmpty();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.doError(a, ex);
                        return;
                    }
                    if (empty) {
                        this.doComplete(a);
                        return;
                    }
                }
                if (missed == (w = this.get())) {
                    this.produced = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        @Override
        void runAsync() {
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            SimpleQueue q = this.queue;
            long e = this.produced;
            while (true) {
                int w;
                boolean d;
                long r = this.requested.get();
                while (e != r) {
                    boolean empty;
                    Object v;
                    d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, ex);
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (++e != (long)this.limit) continue;
                    if (r != Long.MAX_VALUE) {
                        r = this.requested.addAndGet(-e);
                    }
                    this.s.request(e);
                    e = 0L;
                }
                if (e == r) {
                    boolean empty;
                    d = this.done;
                    try {
                        empty = q.isEmpty();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        q.clear();
                        this.doError(a, ex);
                        return;
                    }
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                }
                if (missed == (w = this.get())) {
                    this.produced = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.actual.onNext(null);
                if (!d) continue;
                Throwable e = this.error;
                if (e != null) {
                    this.doError(this.actual, e);
                } else {
                    this.doComplete(this.actual);
                }
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        public T poll() throws Exception {
            Object v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.produced + 1L;
                if (p == (long)this.limit) {
                    this.produced = 0L;
                    this.s.request(p);
                } else {
                    this.produced = p;
                }
            }
            return v;
        }
    }

    static abstract class BaseObserveOnSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements Runnable,
    Subscriber<T> {
        private static final long serialVersionUID = -8241002408341274697L;
        final Scheduler.Worker worker;
        final boolean delayError;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription s;
        SimpleQueue<T> queue;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        int sourceMode;
        long produced;
        boolean outputFused;

        BaseObserveOnSubscriber(Scheduler.Worker worker, boolean delayError, int prefetch) {
            this.worker = worker;
            this.delayError = delayError;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.limit = prefetch != Integer.MAX_VALUE ? prefetch - (prefetch >> 2) : Integer.MAX_VALUE;
        }

        final void initialRequest() {
            if (this.prefetch == Integer.MAX_VALUE) {
                this.s.request(Long.MAX_VALUE);
            } else {
                this.s.request((long)this.prefetch);
            }
        }

        public final void onNext(T t) {
            if (this.sourceMode == 2) {
                this.trySchedule();
                return;
            }
            if (!this.queue.offer(t)) {
                this.s.cancel();
                this.error = new MissingBackpressureException("Queue is full?!");
                this.done = true;
            }
            this.trySchedule();
        }

        public final void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.trySchedule();
        }

        public final void onComplete() {
            this.done = true;
            this.trySchedule();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.trySchedule();
            }
        }

        public final void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.s.cancel();
            this.worker.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        final void trySchedule() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public final void run() {
            if (this.outputFused) {
                this.runBackfused();
            } else if (this.sourceMode == 1) {
                this.runSync();
            } else {
                this.runAsync();
            }
        }

        abstract void runBackfused();

        abstract void runSync();

        abstract void runAsync();

        final boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            this.doError(a, e);
                        } else {
                            this.doComplete(a);
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        this.doError(a, e);
                        return true;
                    }
                    if (empty) {
                        this.doComplete(a);
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doComplete(Subscriber<?> a) {
            try {
                a.onComplete();
            }
            finally {
                this.worker.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doError(Subscriber<?> a, Throwable e) {
            try {
                a.onError(e);
            }
            finally {
                this.worker.dispose();
            }
        }

        @Override
        public final int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public final void clear() {
            this.queue.clear();
        }

        @Override
        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

