/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BehaviorProcessor<T>
extends FlowableProcessor<T> {
    final AtomicReference<BehaviorSubscription<T>[]> subscribers;
    static final Object[] EMPTY_ARRAY = new Object[0];
    static final BehaviorSubscription[] EMPTY = new BehaviorSubscription[0];
    static final BehaviorSubscription[] TERMINATED = new BehaviorSubscription[0];
    final ReadWriteLock lock;
    final Lock readLock;
    final Lock writeLock;
    final AtomicReference<Object> value = new AtomicReference();
    boolean done;
    long index;

    public static <T> BehaviorProcessor<T> create() {
        return new BehaviorProcessor<T>();
    }

    public static <T> BehaviorProcessor<T> createDefault(T defaultValue) {
        ObjectHelper.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorProcessor<T>(defaultValue);
    }

    BehaviorProcessor() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorSubscription[]>(EMPTY);
    }

    BehaviorProcessor(T defaultValue) {
        this();
        this.value.lazySet(ObjectHelper.requireNonNull(defaultValue, "defaultValue is null"));
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        BehaviorSubscription<T> bs = new BehaviorSubscription<T>(s, this);
        s.onSubscribe(bs);
        if (!bs.cancelled) {
            if (this.add(bs)) {
                if (bs.cancelled) {
                    this.remove(bs);
                } else {
                    bs.emitFirst();
                }
            } else {
                Object o = this.value.get();
                if (NotificationLite.isComplete(o)) {
                    s.onComplete();
                } else {
                    s.onError(NotificationLite.getError(o));
                }
            }
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.done) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        if (this.done) {
            return;
        }
        Object o = NotificationLite.next(t);
        this.setCurrent(o);
        for (BehaviorSubscription<T> bs : this.subscribers.get()) {
            bs.emitNext(o, this.index);
        }
    }

    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException();
        }
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        Object o = NotificationLite.error(t);
        for (BehaviorSubscription<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o = NotificationLite.complete();
        for (BehaviorSubscription<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.value.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        Object o = this.value.get();
        if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            return null;
        }
        return NotificationLite.getValue(o);
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        Object o = this.value.get();
        if (o == null || NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        Object v = NotificationLite.getValue(o);
        if (array.length != 0) {
            array[0] = v;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = v;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        Object o = this.value.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.value.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        Object o = this.value.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    boolean add(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b;
        BehaviorSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new BehaviorSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b;
        BehaviorSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    BehaviorSubscription<T>[] terminate(Object terminalValue) {
        BehaviorSubscription<T>[] a = this.subscribers.get();
        if (a != TERMINATED && (a = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
            this.setCurrent(terminalValue);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Object o) {
        this.writeLock.lock();
        try {
            ++this.index;
            this.value.lazySet(o);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static final class BehaviorSubscription<T>
    extends AtomicLong
    implements Subscription,
    Predicate<Object> {
        private static final long serialVersionUID = 3293175281126227086L;
        final Subscriber<? super T> actual;
        final BehaviorProcessor<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        public BehaviorSubscription(Subscriber<? super T> actual, BehaviorProcessor<T> state) {
            this.actual = actual;
            this.state = state;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorSubscription behaviorSubscription = this;
            synchronized (behaviorSubscription) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorProcessor<T> s = this.state;
                Lock readLock = s.readLock;
                readLock.lock();
                try {
                    this.index = s.index;
                    o = s.value.get();
                }
                finally {
                    readLock.unlock();
                }
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                if (this.test(o)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o) {
            if (this.cancelled) {
                return true;
            }
            if (NotificationLite.isComplete(o)) {
                this.cancel();
                this.actual.onComplete();
                return true;
            }
            if (NotificationLite.isError(o)) {
                this.cancel();
                this.actual.onError(NotificationLite.getError(o));
                return true;
            }
            long r = this.get();
            if (r != 0L) {
                this.actual.onNext(NotificationLite.getValue(o));
                if (r != Long.MAX_VALUE) {
                    this.decrementAndGet();
                }
                return false;
            }
            this.cancel();
            this.actual.onError((Throwable)new IllegalStateException("Could not deliver value due to lack of requests"));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                try {
                    q.forEachWhile(this);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.actual.onError(ex);
                    return;
                }
            }
            return;
        }
    }
}

