/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableSwitchMap(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapSubscriber<T, R>(s, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements Subscriber<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapSubscriber<T, R> parent;
        final long index;
        final int bufferSize;
        final SpscArrayQueue<R> queue;
        volatile boolean done;

        public SwitchMapInnerSubscriber(SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
            this.queue = new SpscArrayQueue(bufferSize);
        }

        public void onSubscribe(Subscription s) {
            if (this.index == this.parent.unique) {
                if (SubscriptionHelper.setOnce(this, s)) {
                    s.request((long)this.bufferSize);
                }
            } else {
                s.cancel();
            }
        }

        public void onNext(R t) {
            if (this.index == this.parent.unique) {
                if (!this.queue.offer(t)) {
                    this.onError(new IllegalStateException("Queue full?!"));
                    return;
                }
                this.parent.drain();
            }
        }

        public void onError(Throwable t) {
            if (this.index == this.parent.unique && this.parent.error.addThrowable(t)) {
                this.done = true;
                this.parent.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.index == this.parent.unique) {
                this.done = true;
                this.parent.drain();
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class SwitchMapSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3491074160481096299L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicThrowable error;
        volatile boolean cancelled;
        Subscription s;
        final AtomicReference<SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        static final SwitchMapInnerSubscriber<Object, Object> CANCELLED = new SwitchMapInnerSubscriber(null, -1L, 1);
        volatile long unique;

        public SwitchMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.actual = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.error = new AtomicThrowable();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            long c;
            this.unique = c = this.unique + 1L;
            SwitchMapInnerSubscriber<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p = this.mapper.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.onError(e);
                return;
            }
            if (p == null) {
                this.s.cancel();
                this.onError(new NullPointerException("The publisher returned is null"));
                return;
            }
            SwitchMapInnerSubscriber nextInner = new SwitchMapInnerSubscriber(this, c, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p.subscribe(nextInner);
                break;
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            if (this.error.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            BackpressureHelper.add(this.requested, n);
            if (this.unique == 0L) {
                this.s.request(Long.MAX_VALUE);
            } else {
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.disposeInner();
            }
        }

        void disposeInner() {
            SwitchMapInnerSubscriber<Object, Object> a = this.active.get();
            if (a != CANCELLED && (a = this.active.getAndSet(CANCELLED)) != CANCELLED && a != null) {
                this.s.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super R> a = this.actual;
            int missing = 1;
            while (true) {
                SwitchMapInnerSubscriber<T, R> inner;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    Throwable err;
                    if (this.delayErrors) {
                        if (this.active.get() == null) {
                            err = (Throwable)this.error.get();
                            if (err != null) {
                                a.onError(this.error.terminate());
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                    } else {
                        err = (Throwable)this.error.get();
                        if (err != null) {
                            this.disposeInner();
                            this.s.cancel();
                            a.onError(this.error.terminate());
                            return;
                        }
                        if (this.active.get() == null) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                if ((inner = this.active.get()) != null) {
                    long e;
                    SpscArrayQueue q = inner.queue;
                    if (inner.done) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.error.get();
                            if (err != null) {
                                this.s.cancel();
                                this.disposeInner();
                                a.onError(this.error.terminate());
                                return;
                            }
                            if (q.isEmpty()) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        } else if (q.isEmpty()) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    }
                    long r = this.requested.get();
                    boolean retry = false;
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        if (this.cancelled) {
                            return;
                        }
                        boolean d = inner.done;
                        Object v = q.poll();
                        boolean bl = empty = v == null;
                        if (inner != this.active.get()) {
                            retry = true;
                            break;
                        }
                        if (d) {
                            if (!this.delayErrors) {
                                Throwable err = (Throwable)this.error.get();
                                if (err != null) {
                                    this.s.cancel();
                                    a.onError(this.error.terminate());
                                    return;
                                }
                                if (empty) {
                                    this.active.compareAndSet(inner, null);
                                    retry = true;
                                    break;
                                }
                            } else if (empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (e != 0L && !this.cancelled) {
                        if (r != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e);
                        }
                        ((Subscription)inner.get()).request(e);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super R> a) {
            if (this.cancelled) {
                this.s.cancel();
                return true;
            }
            if (d) {
                Throwable e = (Throwable)this.error.get();
                if (e != null) {
                    this.cancelled = true;
                    this.s.cancel();
                    a.onError(this.error.terminate());
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        static {
            CANCELLED.cancel();
        }
    }
}

