/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReference;

public final class AsyncSubject<T>
extends Subject<T> {
    final State<T> state = new State();
    private static final Object[] EMPTY = new Object[0];

    public static <T> AsyncSubject<T> create() {
        return new AsyncSubject<T>();
    }

    protected AsyncSubject() {
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.state.subscribe(observer);
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.state.subscribers.get() == State.TERMINATED) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T value) {
        this.state.onNext(value);
    }

    @Override
    public void onError(Throwable e) {
        this.state.onError(e);
    }

    @Override
    public void onComplete() {
        this.state.onComplete();
    }

    @Override
    public boolean hasObservers() {
        return this.state.subscribers.get().length != 0;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        Object o = this.state.get();
        if (o != null) {
            if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                return null;
            }
            return NotificationLite.getValue(o);
        }
        return null;
    }

    public Object[] getValues() {
        Object[] a = EMPTY;
        Object[] b = this.getValues(a);
        if (b == EMPTY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        Object o = this.state.get();
        if (o != null) {
            if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                Object v = NotificationLite.getValue(o);
                if (array.length != 0) {
                    array[0] = v;
                    if (array.length != 1) {
                        array[1] = null;
                    }
                } else {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
                    array[0] = v;
                }
            }
        } else if (array.length != 0) {
            array[0] = null;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        return this.state.subscribers.get() == State.TERMINATED && !NotificationLite.isError(this.state.get());
    }

    @Override
    public boolean hasThrowable() {
        return NotificationLite.isError(this.state.get());
    }

    public boolean hasValue() {
        Object o = this.state.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements ObservableSource<T>,
    Observer<T> {
        private static final long serialVersionUID = 4876574210612691772L;
        final AtomicReference<Observer<? super T>[]> subscribers = new AtomicReference<Observer[]>(EMPTY);
        static final Observer[] EMPTY = new Observer[0];
        static final Observer[] TERMINATED = new Observer[0];
        boolean done;

        boolean add(Observer<? super T> s) {
            Observer[] b;
            Observer<? super T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new Observer[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = s;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void remove(Observer<? super T> s) {
            Observer[] b;
            Observer<? super T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    Observer<T> e = a[i];
                    if (!e.equals(s)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new Observer[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        Observer<? super T>[] terminate(Object notification) {
            Observer<? super T>[] a;
            if (this.compareAndSet(this.get(), notification) && (a = this.subscribers.get()) != TERMINATED) {
                return this.subscribers.getAndSet(TERMINATED);
            }
            return TERMINATED;
        }

        void emit(Observer<? super T> t, Object v) {
            if (NotificationLite.isComplete(v)) {
                t.onComplete();
            } else if (NotificationLite.isError(v)) {
                t.onError(NotificationLite.getError(v));
            } else {
                t.onNext(NotificationLite.getValue(v));
                t.onComplete();
            }
        }

        @Override
        public void subscribe(final Observer<? super T> t) {
            Disposable d = Disposables.from(new Runnable(){

                @Override
                public void run() {
                    State.this.remove(t);
                }
            });
            t.onSubscribe(d);
            if (this.add(t)) {
                if (d.isDisposed()) {
                    this.remove(t);
                }
                return;
            }
            Object v = this.get();
            this.emit(t, v);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (this.done) {
                d.dispose();
            }
        }

        @Override
        public void onNext(T value) {
            if (this.done) {
                return;
            }
            if (value == null) {
                this.onError(new NullPointerException());
                return;
            }
            this.lazySet(value);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            if (e == null) {
                e = new NullPointerException();
            }
            for (Observer<T> v : this.terminate(NotificationLite.error(e))) {
                v.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Object value = NotificationLite.getValue(this.get());
            if (value == null) {
                for (Observer<T> v : this.terminate(NotificationLite.complete())) {
                    v.onComplete();
                }
            } else {
                for (Observer v : this.terminate(NotificationLite.next(value))) {
                    v.onNext(value);
                    v.onComplete();
                }
            }
        }
    }
}

