/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscribers.observable.BaseQueueDisposable;

public abstract class DeferredScalarObserver<T, R>
extends BaseQueueDisposable<R>
implements Observer<T> {
    protected final Observer<? super R> actual;
    protected Disposable s;
    protected boolean hasValue;
    protected R value;
    protected int fusionState;
    static final int NOT_FUSED = 0;
    static final int EMPTY = 1;
    static final int READY = 2;
    static final int CONSUMED = 3;
    volatile boolean disposed;

    public DeferredScalarObserver(Observer<? super R> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onError(Throwable t) {
        this.value = null;
        this.actual.onError(t);
    }

    @Override
    public void onComplete() {
        if (this.hasValue) {
            this.complete(this.value);
        } else {
            this.actual.onComplete();
        }
    }

    protected final void complete(R value) {
        if (this.disposed) {
            return;
        }
        if (this.fusionState == 1) {
            this.fusionState = 2;
            this.value = value;
        }
        this.actual.onNext(value);
        if (this.disposed) {
            return;
        }
        this.actual.onComplete();
    }

    @Override
    public final R poll() {
        if (this.fusionState == 2) {
            this.fusionState = 3;
            return this.value;
        }
        return null;
    }

    @Override
    public final boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public final void dispose() {
        this.disposed = true;
        this.s.dispose();
    }

    @Override
    public final boolean isEmpty() {
        return this.fusionState != 2;
    }

    @Override
    public final int requestFusion(int mode) {
        return mode & 2;
    }

    @Override
    public void clear() {
        this.value = null;
        this.fusionState = 3;
    }
}

