/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class CallbackCompletableObserver
extends AtomicReference<Disposable>
implements CompletableObserver,
Disposable,
Consumer<Throwable> {
    private static final long serialVersionUID = -4361286194466301354L;
    final Consumer<? super Throwable> onError;
    final Action onComplete;

    public CallbackCompletableObserver(Action onComplete) {
        this.onError = this;
        this.onComplete = onComplete;
    }

    public CallbackCompletableObserver(Consumer<? super Throwable> onError, Action onComplete) {
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void accept(Throwable e) {
        RxJavaPlugins.onError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            this.onError(ex);
        }
        finally {
            this.lazySet(DisposableHelper.DISPOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        try {
            this.onError.accept(e);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
        finally {
            this.lazySet(DisposableHelper.DISPOSED);
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        DisposableHelper.setOnce(this, d);
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

