/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public enum SingleAwait {


    public static <T> T get(SingleSource<T> source) {
        Throwable e;
        final AtomicReference valueRef = new AtomicReference();
        final AtomicReference errorRef = new AtomicReference();
        final CountDownLatch cdl = new CountDownLatch(1);
        source.subscribe(new SingleObserver<T>(){

            @Override
            public void onError(Throwable e) {
                errorRef.lazySet(e);
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Disposable d) {
            }

            @Override
            public void onSuccess(T value) {
                valueRef.lazySet(value);
                cdl.countDown();
            }
        });
        if (cdl.getCount() != 0L) {
            try {
                cdl.await();
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if ((e = (Throwable)errorRef.get()) != null) {
            throw Exceptions.propagate(e);
        }
        return (T)valueRef.get();
    }
}

