/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableThrottleFirstTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;

    public ObservableThrottleFirstTimed(ObservableSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new DebounceTimedSubscriber<T>(new SerializedObserver<T>(t), this.timeout, this.unit, this.scheduler.createWorker()));
    }

    static final class DebounceTimedSubscriber<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        final Observer<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Disposable s;
        final AtomicReference<Disposable> timer = new AtomicReference();
        static final Disposable NEW_TIMER = new Disposable(){

            @Override
            public void dispose() {
            }

            @Override
            public boolean isDisposed() {
                return true;
            }
        };
        volatile boolean gate;
        boolean done;

        public DebounceTimedSubscriber(Observer<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.gate) {
                this.gate = true;
                this.actual.onNext(t);
                Disposable d = this.timer.get();
                if (d != null) {
                    d.dispose();
                }
                if (this.timer.compareAndSet(d, NEW_TIMER) && !this.timer.compareAndSet(NEW_TIMER, d = this.worker.schedule(this, this.timeout, this.unit))) {
                    d.dispose();
                }
            }
        }

        @Override
        public void run() {
            this.gate = false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            DisposableHelper.dispose(this.timer);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DisposableHelper.dispose(this.timer);
            this.worker.dispose();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.timer);
            this.worker.dispose();
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.timer.get() == DisposableHelper.DISPOSED;
        }
    }
}

