/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;

public final class ObservableScanSeed<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Callable<R> seedSupplier;

    public ObservableScanSeed(ObservableSource<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        R r;
        try {
            r = this.seedSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (r == null) {
            EmptyDisposable.error((Throwable)new NullPointerException("The seed supplied is null"), t);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, R>(t, this.accumulator, r));
    }

    static final class ScanSeedSubscriber<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> actual;
        final BiFunction<R, ? super T, R> accumulator;
        R value;
        Disposable s;
        boolean done;

        public ScanSeedSubscriber(Observer<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            this.actual = actual;
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                this.actual.onNext(this.value);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            R u;
            R v = this.value;
            try {
                u = this.accumulator.apply(v, t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.dispose();
                this.onError(e);
                return;
            }
            if (u == null) {
                this.s.dispose();
                this.onError(new NullPointerException("The accumulator returned a null value"));
                return;
            }
            this.value = u;
            this.actual.onNext(u);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

