/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public enum ObservableScalarXMap {


    public static <T, R> boolean tryScalarXMapSubscribe(ObservableSource<T> source, Observer<? super R> observer, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        if (source instanceof Callable) {
            ObservableSource<R> r;
            Object t;
            try {
                t = ((Callable)((Object)source)).call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (t == null) {
                EmptyDisposable.complete(observer);
                return true;
            }
            try {
                r = ObjectHelper.requireNonNull(mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, observer);
                return true;
            }
            if (r instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)((Object)r)).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptyDisposable.error(ex, observer);
                    return true;
                }
                if (u == null) {
                    EmptyDisposable.complete(observer);
                    return true;
                }
                observer.onSubscribe(new ScalarDisposable<R>(observer, u));
            } else {
                r.subscribe(observer);
            }
            return true;
        }
        return false;
    }

    public static <T, U> Observable<U> scalarXMap(T value, Function<? super T, ? extends ObservableSource<? extends U>> mapper) {
        return RxJavaPlugins.onAssembly(new ScalarXMapObservable(value, mapper));
    }

    public static final class ScalarDisposable<T>
    extends AtomicInteger
    implements QueueDisposable<T>,
    Runnable {
        private static final long serialVersionUID = 3880992722410194083L;
        final Observer<? super T> observer;
        final T value;
        static final int START = 0;
        static final int ON_NEXT = 1;
        static final int ON_COMPLETE = 2;

        public ScalarDisposable(Observer<? super T> observer, T value) {
            this.observer = observer;
            this.value = value;
        }

        @Override
        public boolean offer(T value) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        public boolean offer(T v1, T v2) {
            throw new UnsupportedOperationException("Should not be called!");
        }

        @Override
        public T poll() throws Exception {
            if (this.get() == 0) {
                this.lazySet(2);
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.get() != 0;
        }

        @Override
        public void clear() {
            this.lazySet(2);
        }

        @Override
        public void dispose() {
            this.set(2);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == 2;
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        public void run() {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.observer.onNext(this.value);
                if (this.get() == 1) {
                    this.lazySet(2);
                    this.observer.onComplete();
                }
            }
        }
    }

    static final class ScalarXMapObservable<T, R>
    extends Observable<R> {
        final T value;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;

        public ScalarXMapObservable(T value, Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
            this.value = value;
            this.mapper = mapper;
        }

        @Override
        public void subscribeActual(Observer<? super R> s) {
            ObservableSource<R> other;
            try {
                other = ObjectHelper.requireNonNull(this.mapper.apply(this.value), "The mapper returned a null Publisher");
            }
            catch (Throwable e) {
                EmptyDisposable.error(e, s);
                return;
            }
            if (other instanceof Callable) {
                Object u;
                try {
                    u = ((Callable)((Object)other)).call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptyDisposable.error(ex, s);
                    return;
                }
                if (u == null) {
                    EmptyDisposable.complete(s);
                    return;
                }
                ScalarDisposable<R> sd = new ScalarDisposable<R>(s, u);
                s.onSubscribe(sd);
                sd.run();
            } else {
                other.subscribe(s);
            }
        }
    }
}

