/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends U> function;

    public ObservableMap(ObservableSource<T> source, Function<? super T, ? extends U> function) {
        super(source);
        this.function = function;
    }

    @Override
    public void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new MapperSubscriber<T, U>(t, this.function));
    }

    static final class MapperSubscriber<T, U>
    implements Observer<T>,
    Disposable {
        final Observer<? super U> actual;
        final Function<? super T, ? extends U> function;
        Disposable subscription;
        boolean done;

        public MapperSubscriber(Observer<? super U> actual, Function<? super T, ? extends U> function) {
            this.actual = actual;
            this.function = function;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.subscription, s)) {
                this.subscription = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            U u;
            if (this.done) {
                return;
            }
            try {
                u = this.function.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.subscription.dispose();
                this.onError(e);
                return;
            }
            if (u == null) {
                this.subscription.dispose();
                this.onError(new NullPointerException("Value returned by the function is null"));
                return;
            }
            this.actual.onNext(u);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isDisposed() {
            return this.subscription.isDisposed();
        }

        @Override
        public void dispose() {
            this.subscription.dispose();
        }
    }
}

