/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.observers.DisposableObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

public enum BlockingObservableLatest {


    public static <T> Iterable<T> latest(final ObservableSource<? extends T> source) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                LatestObserverIterator lio = new LatestObserverIterator();
                Observable materialized = Observable.wrap(source).materialize();
                materialized.subscribe(lio);
                return lio;
            }
        };
    }

    static final class LatestObserverIterator<T>
    extends DisposableObserver<Notification<T>>
    implements Iterator<T> {
        Notification<T> iteratorNotification;
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<T>> value = new AtomicReference();

        LatestObserverIterator() {
        }

        @Override
        public void onNext(Notification<T> args) {
            boolean wasNotAvailable;
            boolean bl = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onComplete() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw Exceptions.propagate(this.iteratorNotification.getError());
            }
            if ((this.iteratorNotification == null || this.iteratorNotification.isOnNext()) && this.iteratorNotification == null) {
                Notification n;
                try {
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    this.dispose();
                    Thread.currentThread().interrupt();
                    this.iteratorNotification = Notification.createOnError(ex);
                    throw Exceptions.propagate(ex);
                }
                this.iteratorNotification = n = (Notification)this.value.getAndSet(null);
                if (n.isOnError()) {
                    throw Exceptions.propagate(n.getError());
                }
            }
            return this.iteratorNotification.isOnNext();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iteratorNotification.isOnNext()) {
                T v = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

