/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingObservableIterator<T>
extends AtomicReference<Disposable>
implements Observer<T>,
Iterator<T>,
Runnable,
Disposable {
    private static final long serialVersionUID = 6695226475494099826L;
    final SpscLinkedArrayQueue<T> queue;
    final Lock lock;
    final Condition condition;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;

    public BlockingObservableIterator(int batchSize) {
        this.queue = new SpscLinkedArrayQueue(batchSize);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public boolean hasNext() {
        block5: while (true) {
            if (this.cancelled) {
                return false;
            }
            boolean d = this.done;
            boolean empty = this.queue.isEmpty();
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    throw Exceptions.propagate(e);
                }
                if (empty) {
                    return false;
                }
            }
            if (!empty) break;
            this.lock.lock();
            try {
                while (true) {
                    if (this.cancelled || this.done || !this.queue.isEmpty()) continue block5;
                    this.condition.await();
                }
            }
            catch (InterruptedException ex) {
                this.run();
                throw Exceptions.propagate(ex);
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return true;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T v = this.queue.poll();
            if (v == null) {
                this.run();
                throw new IllegalStateException("Queue empty?!");
            }
            return v;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void onSubscribe(Disposable s) {
        DisposableHelper.setOnce(this, s);
    }

    @Override
    public void onNext(T t) {
        if (!this.queue.offer(t)) {
            DisposableHelper.dispose(this);
            this.onError(new IllegalStateException("Queue full?!"));
        } else {
            this.signalConsumer();
        }
    }

    @Override
    public void onError(Throwable t) {
        this.error = t;
        this.done = true;
        this.signalConsumer();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.signalConsumer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalConsumer() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void run() {
        DisposableHelper.dispose(this);
        this.signalConsumer();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.get());
    }
}

