/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ArrayCompositeDisposable
extends AtomicReferenceArray<Disposable>
implements Disposable {
    private static final long serialVersionUID = 2746389416410565408L;

    public ArrayCompositeDisposable(int capacity) {
        super(capacity);
    }

    public boolean setResource(int index, Disposable resource) {
        Disposable o;
        do {
            if ((o = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return false;
        } while (!this.compareAndSet(index, o, resource));
        if (o != null) {
            o.dispose();
        }
        return true;
    }

    public Disposable replaceResource(int index, Disposable resource) {
        Disposable o;
        do {
            if ((o = (Disposable)this.get(index)) != DisposableHelper.DISPOSED) continue;
            resource.dispose();
            return null;
        } while (!this.compareAndSet(index, o, resource));
        return o;
    }

    @Override
    public void dispose() {
        if (this.get(0) != DisposableHelper.DISPOSED) {
            int s = this.length();
            for (int i = 0; i < s; ++i) {
                Disposable o = (Disposable)this.get(i);
                if (o == DisposableHelper.DISPOSED || (o = this.getAndSet(i, DisposableHelper.DISPOSED)) == DisposableHelper.DISPOSED || o == null) continue;
                o.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get(0) == DisposableHelper.DISPOSED;
    }
}

