/*
 * Decompiled with CFR 0.152.
 */
package rx.joins;

import java.util.ArrayList;
import java.util.List;
import rx.Notification;
import rx.functions.Action0;
import rx.functions.ActionN;
import rx.joins.ActivePlan0;
import rx.joins.JoinObserver1;

public final class ActivePlanN
extends ActivePlan0 {
    private final ActionN onNext;
    private final Action0 onCompleted;
    private final List<JoinObserver1<? extends Object>> observers;

    ActivePlanN(List<JoinObserver1<? extends Object>> observers, ActionN onNext, Action0 onCompleted) {
        this.onNext = onNext;
        this.onCompleted = onCompleted;
        this.observers = new ArrayList<JoinObserver1<? extends Object>>(observers);
        for (JoinObserver1<? extends Object> jo : this.observers) {
            this.addJoinObserver(jo);
        }
    }

    @Override
    protected void match() {
        Object[] notifications = new Object[this.observers.size()];
        int j = 0;
        int completedCount = 0;
        for (JoinObserver1<? extends Object> jo : this.observers) {
            if (jo.queue().isEmpty()) {
                return;
            }
            Notification<? extends Object> n = jo.queue().peek();
            if (n.isOnCompleted()) {
                ++completedCount;
            }
            notifications[j] = n.getValue();
            ++j;
        }
        if (completedCount == j) {
            this.onCompleted.call();
        } else {
            this.dequeue();
            this.onNext.call(notifications);
        }
    }
}

