/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.util.Exceptions;

public abstract class TransportDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportDetector.class);
    private static final Transport TRANSPORT = TransportDetector.determineTransport();

    private static Transport determineTransport() {
        NativeTransport transport = new NativeTransport("io.netty.channel.epoll", "Epoll");
        if (transport.isAvailable()) {
            LOGGER.debug("Using epoll transport");
            return transport;
        }
        transport = new NativeTransport("io.netty.channel.kqueue", "KQueue");
        if (transport.isAvailable()) {
            LOGGER.debug("Using kqueue transport");
            return transport;
        }
        LOGGER.debug("Using nio transport");
        return new NioTransport();
    }

    public static Class<? extends ServerSocketChannel> getServerSocketChannelImpl() {
        return TRANSPORT.getServerSocketChannelImpl();
    }

    public static Class<? extends SocketChannel> getSocketChannelImpl() {
        return TRANSPORT.getSocketChannelImpl();
    }

    public static EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        return TRANSPORT.eventLoopGroup(nThreads, threadFactory);
    }

    private static class NativeTransportImpl {
        private final Class<? extends ServerSocketChannel> serverSocketChannelClass;
        private final Class<? extends SocketChannel> socketChannelClass;
        private final Constructor<? extends EventLoopGroup> constructor;

        NativeTransportImpl(Class<? extends ServerSocketChannel> serverSocketChannelClass, Class<? extends SocketChannel> socketChannelClass, Constructor<? extends EventLoopGroup> constructor) {
            this.serverSocketChannelClass = serverSocketChannelClass;
            this.socketChannelClass = socketChannelClass;
            this.constructor = constructor;
        }

        EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            try {
                return this.constructor.newInstance(nThreads, threadFactory);
            }
            catch (ReflectiveOperationException e) {
                throw Exceptions.uncheck(e);
            }
        }
    }

    private static class NativeTransport
    implements Transport {
        private final NativeTransportImpl impl;

        NativeTransport(String packageName, String classPrefix) {
            String property = "ratpack." + classPrefix.toLowerCase() + ".disable";
            boolean disabled = Boolean.getBoolean(property);
            this.impl = disabled || !NativeTransport.isAvailable(packageName, classPrefix) ? null : NativeTransport.loadImpl(packageName, classPrefix);
        }

        @Override
        public boolean isAvailable() {
            return this.impl != null;
        }

        @Override
        public Class<? extends ServerSocketChannel> getServerSocketChannelImpl() {
            return this.impl.serverSocketChannelClass;
        }

        @Override
        public Class<? extends SocketChannel> getSocketChannelImpl() {
            return this.impl.socketChannelClass;
        }

        @Override
        public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            return this.impl.eventLoopGroup(nThreads, threadFactory);
        }

        private static NativeTransportImpl loadImpl(String packageName, String classPrefix) {
            try {
                Class<ServerSocketChannel> serverSocketChannelClass = NativeTransport.loadClass(ServerSocketChannel.class, packageName, classPrefix, ServerSocketChannel.class.getSimpleName());
                Class<SocketChannel> socketChannelClass = NativeTransport.loadClass(SocketChannel.class, packageName, classPrefix, SocketChannel.class.getSimpleName());
                Class<EventLoopGroup> eventLoopGroupClass = NativeTransport.loadClass(EventLoopGroup.class, packageName, classPrefix, EventLoopGroup.class.getSimpleName());
                Constructor<EventLoopGroup> constructor = eventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class);
                return new NativeTransportImpl(serverSocketChannelClass, socketChannelClass, constructor);
            }
            catch (ReflectiveOperationException e) {
                LOGGER.debug("Failed to load {}", (Object)classPrefix, (Object)e);
                return null;
            }
        }

        private static boolean isAvailable(String packageName, String classPrefix) {
            try {
                Class<Object> clazz = NativeTransport.loadClass(Object.class, packageName, classPrefix, null);
                return NativeTransport.invokeIsAvailable(clazz);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("{} was not found", (Object)packageName);
                return false;
            }
            catch (Exception e) {
                LOGGER.debug("{} failed to load", (Object)packageName, (Object)e);
                return false;
            }
        }

        private static <T> Class<? extends T> loadClass(Class<T> type, String packageName, String classPrefix, String classType) throws ClassNotFoundException {
            Class<?> clazz;
            String name = packageName + "." + classPrefix;
            if (classType != null) {
                name = name + classType;
            }
            if (type.isAssignableFrom(clazz = Thread.currentThread().getContextClassLoader().loadClass(name))) {
                Class<?> cast = clazz;
                return cast;
            }
            throw new ClassCastException("Cannot assign " + clazz + " to " + type);
        }

        private static boolean invokeIsAvailable(Class<?> clazz) {
            Object result;
            try {
                result = clazz.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.debug("{}.isAvailable failed", (Object)clazz.getName(), (Object)e);
                return false;
            }
            if (result instanceof Boolean) {
                Boolean isAvailable = (Boolean)result;
                if (!isAvailable.booleanValue() && LOGGER.isDebugEnabled()) {
                    Object unavailabilityCause;
                    try {
                        unavailabilityCause = clazz.getMethod("unavailabilityCause", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        LOGGER.debug("{}.unavailabilityCause() failed", (Object)clazz.getName(), (Object)e);
                        return false;
                    }
                    if (unavailabilityCause instanceof Throwable) {
                        LOGGER.debug("{} unavailability cause", (Object)clazz.getName(), unavailabilityCause);
                    }
                }
                return isAvailable;
            }
            LOGGER.debug("{}.isAvailable returned {}", (Object)clazz.getName(), result);
            return false;
        }
    }

    private static class NioTransport
    implements Transport {
        private NioTransport() {
        }

        @Override
        public boolean isAvailable() {
            return true;
        }

        @Override
        public Class<? extends ServerSocketChannel> getServerSocketChannelImpl() {
            return NioServerSocketChannel.class;
        }

        @Override
        public Class<? extends SocketChannel> getSocketChannelImpl() {
            return NioSocketChannel.class;
        }

        @Override
        public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            return new NioEventLoopGroup(nThreads, threadFactory);
        }
    }

    private static interface Transport {
        public boolean isAvailable();

        public Class<? extends ServerSocketChannel> getServerSocketChannelImpl();

        public Class<? extends SocketChannel> getSocketChannelImpl();

        public EventLoopGroup eventLoopGroup(int var1, ThreadFactory var2);
    }
}

