/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import ratpack.exec.Downstream;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.internal.Continuation;
import ratpack.exec.internal.DefaultExecution;

class AsyncDownstream<T>
implements Downstream<T> {
    private static final AtomicIntegerFieldUpdater<AsyncDownstream> FIRED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AsyncDownstream.class, "fired");
    volatile int fired;
    private final Continuation continuation;
    private final Downstream<? super T> downstream;

    AsyncDownstream(Continuation continuation, Downstream<? super T> downstream) {
        this.continuation = continuation;
        this.downstream = downstream;
    }

    boolean fire() {
        return FIRED_UPDATER.compareAndSet(this, 0, 1);
    }

    @Override
    public void error(Throwable throwable) {
        if (this.fire()) {
            this.continuation.resume(() -> this.downstream.error(throwable));
        } else {
            DefaultExecution.LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled", throwable));
        }
    }

    @Override
    public void success(T value) {
        if (this.fire()) {
            this.continuation.resume(() -> this.downstream.success(value));
        } else {
            DefaultExecution.LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
        }
    }

    @Override
    public void complete() {
        if (this.fire()) {
            this.continuation.resume(this.downstream::complete);
        } else {
            DefaultExecution.LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
        }
    }
}

