/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.websocket.internal;

import ratpack.core.handling.Context;
import ratpack.core.server.ServerConfig;
import ratpack.core.websocket.WebSocket;
import ratpack.core.websocket.WebSocketClose;
import ratpack.core.websocket.WebSocketConnector;
import ratpack.core.websocket.WebSocketMessage;
import ratpack.core.websocket.WebSocketSpec;
import ratpack.core.websocket.internal.BuiltWebSocketHandler;
import ratpack.core.websocket.internal.WebSocketEngine;
import ratpack.func.Action;
import ratpack.func.Function;

public class DefaultWebSocketConnector<T>
implements WebSocketConnector<T> {
    private final Context context;
    private final Function<WebSocket, T> open;

    public DefaultWebSocketConnector(Context context, Function<WebSocket, T> open) {
        this.context = context;
        this.open = open;
    }

    @Override
    public void connect(Action<? super WebSocketSpec<T>> specAction) throws Exception {
        Spec spec = new Spec(((ServerConfig)this.context.get(ServerConfig.class)).getMaxContentLength());
        specAction.execute((Object)spec);
        WebSocketEngine.connect(this.context, spec.path, spec.maxLength, new BuiltWebSocketHandler<T>(this.open, spec.closeHandler, spec.messageHandler));
    }

    private class Spec
    implements WebSocketSpec<T> {
        private Action<? super WebSocketMessage<T>> messageHandler = Action.noop();
        private Action<? super WebSocketClose<T>> closeHandler = Action.noop();
        private String path = "/";
        private int maxLength;

        private Spec(int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public WebSocketSpec<T> path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public WebSocketSpec<T> onClose(Action<WebSocketClose<T>> action) {
            this.closeHandler = action;
            return this;
        }

        @Override
        public WebSocketSpec<T> onMessage(Action<WebSocketMessage<T>> action) {
            this.messageHandler = action;
            return this;
        }

        @Override
        public WebSocketSpec<T> maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }
    }
}

