/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server.internal;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.config.internal.DefaultEnvironment;
import ratpack.func.Utils;

public class ServerEnvironment
extends DefaultEnvironment {
    public static final ServerEnvironment INSTANCE = new ServerEnvironment(System.getenv(), System.getProperties());
    public static final String ADDRESS_PROPERTY = "ratpack.address";
    public static final String PORT_PROPERTY = "ratpack.port";
    public static final String INTELLIJ_MAIN = "com.intellij.rt.execution.application.AppMain";
    public static final String INTELLIJ_JUNIT = "com.intellij.rt.execution.junit.JUnitStarter";
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerEnvironment.class);
    private static final Pattern STARTS_WITH_SCHEME_PATTERN = Pattern.compile("^(.+)://.+$");
    private static final int MAX_PORT = 65535;

    public ServerEnvironment(Map<String, String> env, Properties properties) {
        super(env, properties);
    }

    public static ServerEnvironment env() {
        return INSTANCE;
    }

    public InetAddress getAddress() {
        return (InetAddress)Utils.get(null, Objects::nonNull, (Supplier[])new Supplier[]{() -> this.parseAddressValue("ratpack.address system property", this.getProperties().getProperty(ADDRESS_PROPERTY)), () -> this.parseAddressValue("RATPACK_ADDRESS env var", (String)this.getenv().get("RATPACK_ADDRESS"))});
    }

    private InetAddress parseAddressValue(String description, String value) {
        if (value == null) {
            return null;
        }
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Failed to parse {} value {} to InetAddress, using default of {}", new Object[]{description, value, null});
            return null;
        }
    }

    public Integer getPort() {
        return (Integer)Utils.get((Object)5050, Objects::nonNull, (Supplier[])new Supplier[]{() -> ServerEnvironment.parsePortValue("ratpack.port system property", this.getProperties().getProperty(PORT_PROPERTY)), () -> ServerEnvironment.parsePortValue("RATPACK_PORT env var", (String)this.getenv().get("RATPACK_PORT")), () -> ServerEnvironment.parsePortValue("PORT env var", (String)this.getenv().get("PORT"))});
    }

    public URI getPublicAddress() {
        return (URI)Utils.get(null, Objects::nonNull, (Supplier[])new Supplier[]{() -> ServerEnvironment.parseUri("'ratpack.publicAddress' system property", this.getProperties().getProperty("ratpack.publicAddress")), () -> ServerEnvironment.parseUri("'RATPACK_PUBLIC_ADDRESS' env var", (String)this.getenv().get("RATPACK_PUBLIC_ADDRESS"))});
    }

    private static URI parseUri(String description, String value) {
        if (value != null) {
            try {
                URI uri = STARTS_WITH_SCHEME_PATTERN.matcher(value).matches() ? new URI(value) : new URI("http://" + value);
                String scheme = uri.getScheme();
                if (scheme.equals("http") || scheme.equals("https")) {
                    return uri;
                }
                LOGGER.warn("Could not use {} value {} as it is not a http/https URI, ignoring value", (Object)description, (Object)value);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Could not convert {} with value {} to a URI ({}), ignoring value", new Object[]{description, value, e.getMessage()});
            }
        }
        return null;
    }

    public static Integer parsePortValue(String description, String value) {
        if (value == null) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < 0 || intValue > 65535) {
                LOGGER.warn("{} value {} is outside of allowed range 0 - {}, using default of {}", new Object[]{description, intValue, 65535, 5050});
                return 5050;
            }
            return intValue;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse {} value {} to int, using default of {}", new Object[]{description, value, 5050});
            return 5050;
        }
    }
}

