/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import ratpack.core.bytebuf.ByteBufRef;
import ratpack.core.http.ConnectionClosedException;
import ratpack.core.http.RequestBodyAlreadyReadException;
import ratpack.core.http.RequestBodyTooLargeException;
import ratpack.core.server.internal.ConnectionClosureReason;
import ratpack.core.server.internal.RequestBodyAccumulator;
import ratpack.core.server.internal.RequestBodyReader;
import ratpack.exec.Downstream;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.stream.TransformablePublisher;
import ratpack.exec.stream.internal.BufferedWriteStream;
import ratpack.exec.stream.internal.BufferingPublisher;
import ratpack.func.Block;

public class RequestBody
implements RequestBodyReader,
RequestBodyAccumulator {
    private static final HttpResponse CONTINUE_RESPONSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private final List<ByteBuf> received = new ArrayList<ByteBuf>();
    private final long advertisedLength;
    private final HttpRequest request;
    private final ChannelHandlerContext ctx;
    private long maxContentLength = -1L;
    private long receivedLength;
    private boolean receivedLast;
    private boolean earlyClose;
    private State state = State.UNREAD;
    private Listener listener;

    public RequestBody(long advertisedLength, HttpRequest request, ChannelHandlerContext ctx) {
        this.advertisedLength = advertisedLength;
        this.request = request;
        this.ctx = ctx;
    }

    @Override
    public void onClose() {
        if (!this.receivedLast) {
            if (this.listener == null) {
                this.earlyClose = true;
            } else {
                this.listener.onEarlyClose();
            }
        }
    }

    public Promise<ByteBuf> read(final Block onTooLarge) {
        return Promise.async(downstream -> {
            if (this.state != State.UNREAD) {
                downstream.error((Throwable)new RequestBodyAlreadyReadException());
                return;
            }
            this.state = State.READING;
            if (this.isExceedsMaxContentLength(this.advertisedLength)) {
                this.tooLarge(onTooLarge, this.advertisedLength, (Downstream<? super ByteBuf>)downstream);
            } else if (this.isExceedsMaxContentLength(this.receivedLength)) {
                this.tooLarge(onTooLarge, this.receivedLength, (Downstream<? super ByteBuf>)downstream);
            } else if (this.receivedLast) {
                this.complete((Downstream<? super ByteBuf>)downstream);
            } else if (this.earlyClose) {
                this.discard();
                downstream.error((Throwable)this.closedException());
            } else {
                this.listener = new Listener(){

                    @Override
                    public void onContent(HttpContent httpContent) {
                        RequestBody.this.addToReceived(httpContent);
                        if (RequestBody.this.isExceedsMaxContentLength(RequestBody.this.receivedLength)) {
                            RequestBody.this.tooLarge(onTooLarge, RequestBody.this.receivedLength, (Downstream<? super ByteBuf>)downstream);
                        } else if (httpContent instanceof LastHttpContent) {
                            RequestBody.this.listener = null;
                            RequestBody.this.complete((Downstream<? super ByteBuf>)downstream);
                        } else {
                            RequestBody.this.ctx.channel().read();
                        }
                    }

                    @Override
                    public void onEarlyClose() {
                        RequestBody.this.discard();
                        RequestBody.this.listener = null;
                        downstream.error((Throwable)RequestBody.this.closedException());
                    }
                };
                this.startBodyRead(e -> {
                    this.discard();
                    downstream.error(e);
                });
            }
        }).map(byteBuf -> {
            Execution.current().onComplete(() -> {
                if (byteBuf.refCnt() > 0) {
                    byteBuf.release();
                }
            });
            return byteBuf;
        });
    }

    private void tooLarge(Block onTooLarge, long length, Downstream<? super ByteBuf> downstream) {
        this.discard();
        this.state = State.TOO_LARGE;
        if (onTooLarge == DEFAULT_TOO_LARGE_SENTINEL) {
            downstream.error((Throwable)this.tooLargeException(length));
        } else {
            try {
                onTooLarge.execute();
            }
            catch (Throwable t) {
                downstream.error(t);
                return;
            }
            downstream.complete();
        }
    }

    private boolean isExceedsMaxContentLength(long contentLength) {
        return this.maxContentLength > 0L && contentLength > 0L && contentLength > this.maxContentLength;
    }

    private void startBodyRead(Consumer<? super Throwable> errorHandler) {
        if (this.isContinueExpected()) {
            this.ctx.writeAndFlush((Object)CONTINUE_RESPONSE).addListener(future -> {
                if (future.isSuccess()) {
                    this.ctx.read();
                } else {
                    errorHandler.accept(future.cause());
                }
            });
        } else {
            this.ctx.read();
        }
    }

    public TransformablePublisher<ByteBuf> readStream() {
        return new BufferingPublisher(ReferenceCounted::release, write -> {
            if (this.state != State.UNREAD) {
                throw new RequestBodyAlreadyReadException();
            }
            this.state = State.READING;
            if (this.isExceedsMaxContentLength(this.advertisedLength) || this.isExceedsMaxContentLength(this.receivedLength)) {
                this.discard();
                this.state = State.TOO_LARGE;
                throw this.tooLargeException(Math.max(this.advertisedLength, this.receivedLength));
            }
            return new Subscription((BufferedWriteStream)write){
                final /* synthetic */ BufferedWriteStream val$write;
                {
                    this.val$write = bufferedWriteStream;
                }

                public void request(long n) {
                    if (RequestBody.this.listener == null) {
                        ByteBuf alreadyReceived = RequestBody.this.composeReceived();
                        if (alreadyReceived.readableBytes() > 0) {
                            this.val$write.item((Object)alreadyReceived);
                        } else {
                            alreadyReceived.release();
                        }
                        if (RequestBody.this.receivedLast) {
                            RequestBody.this.state = State.READ;
                            this.val$write.complete();
                        } else {
                            RequestBody.this.listener = new Listener(){

                                @Override
                                public void onContent(HttpContent httpContent) {
                                    ByteBuf byteBuf = httpContent.content().touch();
                                    int readableBytes = byteBuf.readableBytes();
                                    if (readableBytes > 0) {
                                        RequestBody.this.receivedLength += readableBytes;
                                        if (RequestBody.this.isExceedsMaxContentLength(RequestBody.this.receivedLength)) {
                                            RequestBody.this.state = State.TOO_LARGE;
                                            byteBuf.release();
                                            RequestBody.this.discard();
                                            RequestBody.this.listener = null;
                                            val$write.error((Throwable)RequestBody.this.tooLargeException(RequestBody.this.receivedLength));
                                            return;
                                        }
                                        val$write.item((Object)byteBuf.touch());
                                    } else {
                                        byteBuf.release();
                                    }
                                    if (httpContent instanceof LastHttpContent) {
                                        RequestBody.this.state = State.READ;
                                        RequestBody.this.listener = null;
                                        val$write.complete();
                                    } else if (val$write.getRequested() > 0L) {
                                        RequestBody.this.ctx.channel().read();
                                    }
                                }

                                @Override
                                public void onEarlyClose() {
                                    RequestBody.this.discard();
                                    RequestBody.this.listener = null;
                                    val$write.error((Throwable)RequestBody.this.closedException());
                                }
                            };
                            if (RequestBody.this.earlyClose) {
                                RequestBody.this.listener.onEarlyClose();
                            } else {
                                RequestBody.this.startBodyRead(e -> {
                                    RequestBody.this.discard();
                                    this.val$write.error(e);
                                });
                            }
                        }
                    } else {
                        RequestBody.this.ctx.read();
                    }
                }

                public void cancel() {
                    RequestBody.this.discard();
                }
            };
        }).bindExec(ReferenceCounted::release);
    }

    private RequestBodyTooLargeException tooLargeException(long receivedLength) {
        return new RequestBodyTooLargeException(this.maxContentLength, receivedLength);
    }

    private ConnectionClosedException closedException() {
        return new ConnectionClosedException(ConnectionClosureReason.get(this.ctx.channel()));
    }

    @Override
    public void add(HttpContent httpContent) {
        if (this.state == State.READ || this.state == State.TOO_LARGE) {
            httpContent.release();
        } else {
            if (httpContent instanceof LastHttpContent) {
                this.receivedLast = true;
            }
            if (this.listener == null) {
                this.addToReceived(httpContent);
            } else {
                this.listener.onContent(httpContent);
            }
        }
    }

    private void addToReceived(HttpContent httpContent) {
        ByteBuf byteBuf = httpContent.content().touch();
        int readableBytes = byteBuf.readableBytes();
        if (readableBytes > 0) {
            this.receivedLength += (long)readableBytes;
            this.received.add(byteBuf);
        } else {
            byteBuf.release();
        }
    }

    private void release() {
        this.received.forEach(ReferenceCounted::release);
        this.received.clear();
    }

    private void discard() {
        this.state = State.DISCARDED;
        this.release();
    }

    private void complete(Downstream<? super ByteBuf> downstream) {
        this.state = State.READ;
        if (this.received.isEmpty()) {
            downstream.success((Object)Unpooled.EMPTY_BUFFER);
        } else {
            downstream.success((Object)this.composeReceived());
        }
    }

    private ByteBuf composeReceived() {
        if (this.received.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.received.size() == 1) {
            return new ByteBufRef(this.received.remove(0));
        }
        ByteBuf[] byteBufsArray = this.received.toArray(new ByteBuf[0]);
        this.received.clear();
        return Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])byteBufsArray);
    }

    public Promise<DrainOutcome> drain() {
        return Promise.flatten(() -> {
            this.release();
            if (this.state == State.READ) {
                return DrainOutcome.DRAINED.promise;
            }
            if (this.state == State.TOO_LARGE) {
                return DrainOutcome.TOO_LARGE.promise;
            }
            if (this.state == State.DISCARDED) {
                return DrainOutcome.DISCARDED.promise;
            }
            this.state = State.READING;
            if (this.receivedLast || this.isContinueExpected()) {
                if (this.isContinueExpected()) {
                    this.ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
                }
                this.release();
                this.state = State.READ;
                return DrainOutcome.DRAINED.promise;
            }
            if (this.advertisedLength > this.maxContentLength || this.receivedLength > this.maxContentLength) {
                this.discard();
                this.state = State.TOO_LARGE;
                return DrainOutcome.TOO_LARGE.promise;
            }
            return Promise.async(down -> {
                this.listener = new Listener(){

                    @Override
                    public void onContent(HttpContent httpContent) {
                        httpContent.release();
                        if ((RequestBody.this.receivedLength += httpContent.content().readableBytes()) > RequestBody.this.maxContentLength) {
                            RequestBody.this.state = State.TOO_LARGE;
                            RequestBody.this.listener = null;
                            down.success((Object)DrainOutcome.TOO_LARGE);
                        } else if (httpContent instanceof LastHttpContent) {
                            RequestBody.this.state = State.READ;
                            RequestBody.this.listener = null;
                            down.success((Object)DrainOutcome.DRAINED);
                        } else {
                            RequestBody.this.ctx.read();
                        }
                    }

                    @Override
                    public void onEarlyClose() {
                        down.success((Object)DrainOutcome.DRAINED);
                    }
                };
                this.ctx.read();
            });
        });
    }

    @Override
    public long getContentLength() {
        return this.advertisedLength;
    }

    @Override
    public void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    @Override
    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    private boolean isContinueExpected() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.request);
    }

    static enum DrainOutcome {
        DRAINED,
        TOO_LARGE,
        DISCARDED;

        final Promise<DrainOutcome> promise = Promise.value((Object)((Object)this));
    }

    static interface Listener {
        public void onContent(HttpContent var1);

        public void onEarlyClose();
    }

    static enum State {
        UNREAD,
        READING,
        READ,
        DISCARDED,
        TOO_LARGE;

    }
}

