/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.server.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import ratpack.core.server.internal.ResponseBodyWriter;
import ratpack.exec.Blocking;

class ChunkedFileResponseBodyWriter
implements ResponseBodyWriter {
    private final Path file;

    ChunkedFileResponseBodyWriter(Path file) {
        this.file = file;
    }

    @Override
    public ChannelFuture write(Channel channel) {
        ChannelPromise channelPromise = channel.newPromise();
        Blocking.get(() -> Files.newByteChannel(this.file, new OpenOption[0])).then(fileChannel -> {
            channel.write((Object)new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)fileChannel)), channelPromise);
            channel.flush();
        });
        return channelPromise;
    }
}

