/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.path.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.core.path.PathBinderBuilder;
import ratpack.core.path.internal.PathTokenProcessor;

public enum PathTokenType implements PathTokenProcessor
{
    OPTIONAL_TOKEN_WITH_PATTERN("/?:(\\w*)\\?:(.+)"){

        @Override
        public void process(Matcher matcher, PathBinderBuilder builder) {
            builder.optionalTokenWithPattern(matcher.group(1), matcher.group(2));
        }
    }
    ,
    LITERAL_WITH_PATTERN("/?::(.+)"){

        @Override
        public void process(Matcher matcher, PathBinderBuilder builder) {
            builder.literalPattern(matcher.group(1));
        }
    }
    ,
    TOKEN_WITH_PATTERN("/?:(\\w*):(.+)"){

        @Override
        public void process(Matcher matcher, PathBinderBuilder builder) {
            builder.tokenWithPattern(matcher.group(1), matcher.group(2));
        }
    }
    ,
    TOKEN("/?:(\\w*)"){

        @Override
        public void process(Matcher matcher, PathBinderBuilder builder) {
            builder.token(matcher.group(1));
        }
    }
    ,
    OPTIONAL_TOKEN("/?:(\\w*)\\?"){

        @Override
        public void process(Matcher matcher, PathBinderBuilder builder) {
            builder.optionalToken(matcher.group(1));
        }
    };

    private Pattern pattern;

    public boolean match(String component, PathBinderBuilder builder) {
        Matcher matcher = this.pattern.matcher(component);
        if (matcher.matches()) {
            this.process(matcher, builder);
            return true;
        }
        return false;
    }

    private PathTokenType(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }
}

