/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import ratpack.core.http.MediaType;
import ratpack.core.http.TypedData;

public class ByteBufBackedTypedData
implements TypedData {
    private final ByteBuf byteBuf;
    private final MediaType mediaType;

    public ByteBufBackedTypedData(ByteBuf byteBuf, MediaType mediaType) {
        this.mediaType = mediaType;
        this.byteBuf = byteBuf;
    }

    @Override
    public MediaType getContentType() {
        return this.mediaType;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.byteBuf.asReadOnly();
    }

    @Override
    public String getText() {
        return this.getText(CharsetUtil.UTF_8);
    }

    @Override
    public String getText(Charset charset) {
        if (this.mediaType == null) {
            return this.byteBuf.toString(charset);
        }
        return this.byteBuf.toString(Charset.forName(this.mediaType.getCharset(charset.name())));
    }

    @Override
    public byte[] getBytes() {
        return ByteBufUtil.getBytes((ByteBuf)this.byteBuf);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.byteBuf.resetReaderIndex();
        this.byteBuf.readBytes(outputStream, this.byteBuf.writerIndex());
    }

    @Override
    public InputStream getInputStream() {
        return new ByteBufInputStream(this.byteBuf);
    }
}

