/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.http.client.internal;

import java.net.URI;
import java.time.Duration;
import ratpack.exec.Execution;

final class HttpChannelKey {
    final boolean ssl;
    final int port;
    final String host;
    final Execution execution;
    final Duration connectTimeout;

    HttpChannelKey(URI uri, Duration connectTimeout, Execution execution) {
        switch (uri.getScheme()) {
            case "https": {
                this.ssl = true;
                break;
            }
            case "http": {
                this.ssl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("URI " + uri + " is not HTTP or HTTPS");
            }
        }
        this.port = uri.getPort() < 0 ? (this.ssl ? 443 : 80) : uri.getPort();
        this.host = uri.getHost();
        this.execution = execution;
        this.connectTimeout = connectTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpChannelKey that = (HttpChannelKey)o;
        return this.execution.getController() == that.execution.getController() && this.ssl == that.ssl && this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.ssl ? 1 : 0;
        result = 31 * result + this.port;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.execution.getController().hashCode();
        return result;
    }
}

