/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.health;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import ratpack.core.health.HealthCheck;

public class HealthCheckResults {
    private final ImmutableSortedMap<String, HealthCheck.Result> results;
    private static final HealthCheckResults EMPTY = new HealthCheckResults((ImmutableSortedMap<String, HealthCheck.Result>)ImmutableSortedMap.of());
    private final boolean unhealthy;

    public static HealthCheckResults empty() {
        return EMPTY;
    }

    public HealthCheckResults(ImmutableSortedMap<String, HealthCheck.Result> results) {
        this.results = results;
        this.unhealthy = Iterables.any((Iterable)results.values(), (Predicate)Predicates.not(HealthCheck.Result::isHealthy));
    }

    public ImmutableSortedMap<String, HealthCheck.Result> getResults() {
        return this.results;
    }

    public boolean isUnhealthy() {
        return this.unhealthy;
    }

    public void writeTo(Writer writer) throws IOException {
        boolean first = true;
        for (Map.Entry entry : this.results.entrySet()) {
            Throwable error;
            if (first) {
                first = false;
            } else {
                writer.write("\n");
            }
            String name = (String)entry.getKey();
            HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
            writer.append(name).append(" : ").append(result.isHealthy() ? "HEALTHY" : "UNHEALTHY");
            String message = result.getMessage();
            if (message != null) {
                writer.append(" [").append(message).append("]");
            }
            if ((error = result.getError()) == null) continue;
            writer.append(" [").append(error.toString()).append("]");
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeTo(stringWriter);
        }
        catch (IOException e) {
            return "HealthCheckResults";
        }
        return stringWriter.toString();
    }
}

