/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.handling;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.handling.internal.Extractions;
import ratpack.func.Exceptions;
import ratpack.func.Types;

public abstract class InjectionHandler
implements Handler {
    private final List<TypeToken<?>> types;
    private final Method handleMethod;

    protected InjectionHandler() throws NoSuitableHandleMethodException {
        Class<?> thisClass = this.getClass();
        Method handleMethod = null;
        for (Method method : thisClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("handle") || (parameterTypes = method.getParameterTypes()).length < 2 || !parameterTypes[0].equals(Context.class)) continue;
            handleMethod = method;
            break;
        }
        if (handleMethod == null) {
            throw new NoSuitableHandleMethodException((Class)thisClass);
        }
        try {
            handleMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new NoSuitableHandleMethodException(thisClass, e);
        }
        this.handleMethod = handleMethod;
        Type[] parameterTypes = handleMethod.getGenericParameterTypes();
        this.types = new ArrayList(parameterTypes.length - 1);
        for (int i = 1; i < parameterTypes.length; ++i) {
            this.types.add(Types.token((Type)parameterTypes[i]));
        }
    }

    @Override
    public final void handle(Context context) {
        Object[] args = new Object[this.types.size() + 1];
        args[0] = context;
        Extractions.extract(this.types, context, args, 1);
        try {
            this.handleMethod.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getTargetException();
            throw Exceptions.uncheck((Throwable)root);
        }
    }

    public static class NoSuitableHandleMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private NoSuitableHandleMethodException(Class<?> clazz) {
            super("No injectable handle method found for " + clazz.getName());
        }

        public NoSuitableHandleMethodException(Class<?> clazz, SecurityException cause) {
            super("Unable to make handle method accessible for " + clazz.getName(), cause);
        }
    }
}

