/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.file.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ExecutionException;
import ratpack.config.FileSystemBinding;
import ratpack.core.file.BaseDirRequiredException;
import ratpack.core.handling.Context;
import ratpack.core.handling.Handler;
import ratpack.core.handling.internal.ChainHandler;
import ratpack.core.server.ServerConfig;
import ratpack.exec.registry.Registry;

public class FileSystemBindingHandler
implements Handler {
    private final String path;
    private final Handler[] handler;
    private static final Cache<FileSystemBinding, Registry> CACHE = Caffeine.newBuilder().build();

    public FileSystemBindingHandler(ServerConfig serverConfig, String path, Handler handler) {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("An application base directory is required to use this handler");
        }
        this.path = path;
        this.handler = ChainHandler.unpack(handler);
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        FileSystemBinding parentBinding = (FileSystemBinding)context.get(FileSystemBinding.class);
        FileSystemBinding binding = parentBinding.binding(this.path);
        if (binding == null) {
            context.clientError(404);
        } else {
            context.insert((Registry)CACHE.get((Object)binding, FileSystemBindingHandler::registry), this.handler);
        }
    }

    private static Registry registry(FileSystemBinding binding) {
        return Registry.single(FileSystemBinding.class, (Object)binding);
    }
}

