/*
 * Decompiled with CFR 0.152.
 */
package ratpack.core.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.google.common.base.CaseFormat;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import java.io.IOException;
import java.util.Iterator;

public class SniSslContextDeserializer
extends JsonDeserializer<Mapping<String, SslContext>> {
    public Mapping<String, SslContext> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        SslContext defaultContext;
        ObjectCodec codec = jp.getCodec();
        ObjectNode sslNode = (ObjectNode)jp.readValueAsTree();
        try {
            defaultContext = SniSslContextDeserializer.toValue(codec, (JsonNode)sslNode, SslContext.class);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("error with default ssl context: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("error with default ssl context: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOException("error with default ssl context: " + e.getMessage(), e);
        }
        if (defaultContext == null) {
            throw new IllegalStateException("default ssl context must be specified if any ssl properties are set");
        }
        DomainWildcardMappingBuilder builder = new DomainWildcardMappingBuilder((Object)defaultContext);
        if (sslNode != null) {
            Iterator iter = sslNode.fieldNames();
            while (iter.hasNext()) {
                String domain = (String)iter.next();
                JsonNode domainNode = sslNode.get(domain);
                if (!domainNode.isObject()) continue;
                try {
                    SslContext domainContext = SniSslContextDeserializer.toValue(codec, domainNode, SslContext.class);
                    builder.add(this.normalizeDomainName(domain), (Object)domainContext);
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("error with " + domain + " ssl context: " + e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("error with " + domain + " ssl context: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new IOException("error with " + domain + " ssl context: " + e.getMessage(), e);
                }
            }
        }
        return builder.build();
    }

    protected String normalizeDomainName(String domain) {
        boolean prependWildcard = domain.startsWith("_");
        String normalizedDomain = (String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE).convert((Object)domain);
        normalizedDomain = normalizedDomain.replaceAll("_", ".");
        return prependWildcard ? "*" + normalizedDomain : normalizedDomain;
    }

    private static <T> T toValue(ObjectCodec codec, JsonNode node, Class<T> valueType) throws JsonProcessingException {
        Object pojo;
        if (node.isPojo() && valueType.isInstance(pojo = ((POJONode)node).getPojo())) {
            return valueType.cast(pojo);
        }
        return (T)codec.treeToValue((TreeNode)node, valueType);
    }
}

