/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket.internal;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.websocket.WebSocket;

public class DefaultWebSocket
implements WebSocket {
    private final Channel channel;
    private final Runnable onClose;
    private final AtomicBoolean open;

    public DefaultWebSocket(Channel channel, AtomicBoolean open, Runnable onClose) {
        this.channel = channel;
        this.onClose = onClose;
        this.open = open;
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        this.open.set(false);
        this.channel.writeAndFlush((Object)new CloseWebSocketFrame(statusCode, reason));
        this.channel.close().addListener(future -> this.onClose.run());
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void send(String text) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(text));
    }

    @Override
    public void send(ByteBuf text) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(text));
    }
}

