/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultClientErrorHandler;
import ratpack.error.internal.DefaultServerErrorHandler;
import ratpack.error.internal.ErrorCatchingHandler;
import ratpack.event.internal.DefaultEventController;
import ratpack.file.FileRenderer;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.DefaultFileHttpTransmitter;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.form.internal.FormParser;
import ratpack.func.Action;
import ratpack.handling.Background;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.direct.internal.DefaultDirectChannelAccess;
import ratpack.handling.internal.ClientErrorForwardingHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.handling.internal.DelegatingHeaders;
import ratpack.http.MutableHeaders;
import ratpack.http.Request;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultMutableStatus;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.launch.LaunchConfig;
import ratpack.launch.internal.LaunchConfigInternal;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.render.CharSequenceRenderer;
import ratpack.render.internal.DefaultCharSequenceRenderer;
import ratpack.render.internal.DefaultRenderController;
import ratpack.server.PublicAddress;
import ratpack.server.Stopper;
import ratpack.server.internal.DefaultPublicAddress;
import ratpack.server.internal.InetSocketAddressBackedBindAddress;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Handler[] handlers;
    private final Handler return404;
    private final ConcurrentHashMap<Channel, Action<Object>> channelSubscriptions = new ConcurrentHashMap(0);
    private final DefaultContext.ApplicationConstants applicationConstants;
    private Registry registry;

    public NettyHandlerAdapter(Stopper stopper, Handler handler, LaunchConfig launchConfig) {
        this.handlers = new Handler[]{new ErrorCatchingHandler(handler)};
        this.return404 = new ClientErrorForwardingHandler(HttpResponseStatus.NOT_FOUND.code());
        this.registry = Registries.registry().add(Background.class, launchConfig.getBackground()).add(Stopper.class, stopper).add(FileSystemBinding.class, launchConfig.getBaseDir()).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, new DefaultPublicAddress(launchConfig.getPublicAddress(), launchConfig.getSSLContext() == null ? "http" : "https")).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, new DefaultClientErrorHandler()).add(ServerErrorHandler.class, new DefaultServerErrorHandler()).add(LaunchConfig.class, launchConfig).add(FileRenderer.class, new DefaultFileRenderer()).add(CharSequenceRenderer.class, new DefaultCharSequenceRenderer()).add(FormParser.class, FormParser.multiPart()).add(FormParser.class, FormParser.urlEncoded()).build();
        if (!(launchConfig instanceof LaunchConfigInternal)) {
            throw new IllegalArgumentException("launchConfig must implement internal protocol " + LaunchConfigInternal.class.getName());
        }
        ThreadLocal<Context> contextThreadLocal = ((LaunchConfigInternal)launchConfig).getContextThreadLocal();
        this.applicationConstants = new DefaultContext.ApplicationConstants(launchConfig.getForeground(), launchConfig.getBackground(), contextThreadLocal, new DefaultRenderController());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Action<Object> subscriber;
        if (!(msg instanceof FullHttpRequest) && (subscriber = this.channelSubscriptions.get(ctx.channel())) != null) {
            subscriber.execute(msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest nettyRequest) throws Exception {
        if (!nettyRequest.getDecoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        DefaultRequest request = new DefaultRequest(new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.getMethod().name(), nettyRequest.getUri(), nettyRequest.content());
        final Channel channel = ctx.channel();
        final DefaultMutableStatus responseStatus = new DefaultMutableStatus();
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders(false);
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)httpHeaders);
        DefaultFileHttpTransmitter fileHttpTransmitter = new DefaultFileHttpTransmitter(nettyRequest, (HttpHeaders)httpHeaders, channel);
        DefaultEventController requestOutcomeEventController = new DefaultEventController();
        nettyRequest.content().retain();
        DefaultResponse response = new DefaultResponse(responseStatus, responseHeaders, fileHttpTransmitter, ctx.alloc(), (Action<? super ByteBuf>)new Action<ByteBuf>((HttpHeaders)httpHeaders, nettyRequest, (MutableHeaders)responseHeaders, channel, requestOutcomeEventController, (Request)request){
            final /* synthetic */ HttpHeaders val$httpHeaders;
            final /* synthetic */ FullHttpRequest val$nettyRequest;
            final /* synthetic */ MutableHeaders val$responseHeaders;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ DefaultEventController val$requestOutcomeEventController;
            final /* synthetic */ Request val$request;
            {
                this.val$httpHeaders = httpHeaders;
                this.val$nettyRequest = fullHttpRequest;
                this.val$responseHeaders = mutableHeaders;
                this.val$channel = channel;
                this.val$requestOutcomeEventController = defaultEventController;
                this.val$request = request;
            }

            @Override
            public void execute(ByteBuf byteBuf) {
                CustomHttpResponse nettyResponse = new CustomHttpResponse(responseStatus.getResponseStatus(), this.val$httpHeaders);
                this.val$nettyRequest.content().release();
                this.val$responseHeaders.set(HttpHeaderConstants.CONTENT_LENGTH, byteBuf.writerIndex());
                boolean shouldClose = true;
                if (this.val$channel.isOpen()) {
                    if (HttpHeaders.isKeepAlive((HttpMessage)this.val$nettyRequest)) {
                        this.val$responseHeaders.set(HttpHeaderConstants.CONNECTION, HttpHeaderConstants.KEEP_ALIVE);
                        shouldClose = false;
                    }
                    this.val$channel.writeAndFlush((Object)nettyResponse);
                    this.val$channel.write((Object)byteBuf);
                    ChannelFuture future = this.val$channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                    if (this.val$requestOutcomeEventController.isHasListeners()) {
                        DelegatingHeaders headers = new DelegatingHeaders(this.val$responseHeaders);
                        DefaultStatus status = new DefaultStatus(responseStatus.getCode(), responseStatus.getMessage());
                        DefaultSentResponse sentResponse = new DefaultSentResponse(headers, status);
                        DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.val$request, sentResponse, System.currentTimeMillis());
                        this.val$requestOutcomeEventController.fire(requestOutcome);
                    }
                    if (shouldClose) {
                        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
            }
        });
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        InetSocketAddressBackedBindAddress bindAddress = new InetSocketAddressBackedBindAddress(socketAddress);
        Action<Action<Object>> subscribeHandler = new Action<Action<Object>>(){

            @Override
            public void execute(Action<Object> thing) throws Exception {
                NettyHandlerAdapter.this.channelSubscriptions.put(channel, thing);
                channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        NettyHandlerAdapter.this.channelSubscriptions.remove(channel);
                    }
                });
            }
        };
        DefaultDirectChannelAccess directChannelAccess = new DefaultDirectChannelAccess(channel, subscribeHandler);
        DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, bindAddress, request, response, directChannelAccess, requestOutcomeEventController.getRegistry());
        DefaultContext context = new DefaultContext(requestConstants, this.registry, this.handlers, 0, this.return404);
        context.next();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            cause.printStackTrace();
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().equals("Connection reset by peer");
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

