/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import ratpack.http.Headers;
import ratpack.http.HttpMethod;
import ratpack.http.Request;
import ratpack.http.TypedData;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultHttpMethod;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.MultiValueMap;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public class DefaultRequest
implements Request {
    private final Headers headers;
    private final ByteBuf content;
    private final String uri;
    private TypedData body;
    private ImmutableDelegatingMultiValueMap<String, String> queryParams;
    private String query;
    private String path;
    private final HttpMethod method;
    private Set<Cookie> cookies;

    public DefaultRequest(Headers headers, String methodName, String uri, ByteBuf content) {
        this.headers = headers;
        this.content = content;
        this.method = new DefaultHttpMethod(methodName);
        this.uri = uri;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.getUri());
            this.queryParams = new ImmutableDelegatingMultiValueMap(queryStringDecoder.parameters());
        }
        return this.queryParams;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getQuery() {
        if (this.query == null) {
            String uri = this.getUri();
            int i = uri.indexOf("?");
            this.query = i < 0 || i == uri.length() ? "" : uri.substring(i + 1);
        }
        return this.query;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            String uri = this.getUri();
            String noSlash = uri.substring(1);
            int i = noSlash.indexOf("?");
            this.path = i < 0 ? noSlash : noSlash.substring(0, i);
        }
        return this.path;
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            String header = this.headers.get("Cookie");
            this.cookies = header == null || header.length() == 0 ? Collections.emptySet() : CookieDecoder.decode((String)header);
        }
        return this.cookies;
    }

    @Override
    public String oneCookie(String name) {
        Cookie found = null;
        ArrayList<Cookie> allFound = null;
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            if (found == null) {
                found = cookie;
                continue;
            }
            if (allFound == null) {
                allFound = new ArrayList<Cookie>(2);
                allFound.add(found);
                continue;
            }
            allFound.add(cookie);
        }
        if (found == null) {
            return null;
        }
        if (allFound != null) {
            StringBuilder s = new StringBuilder("Multiple cookies with name '").append(name).append("': ");
            int i = 0;
            for (Cookie cookie : allFound) {
                s.append(cookie.toString());
                if (++i >= allFound.size()) continue;
                s.append(", ");
            }
            throw new IllegalStateException(s.toString());
        }
        return found.getValue();
    }

    @Override
    public TypedData getBody() {
        if (this.body == null) {
            this.body = new ByteBufBackedTypedData(this.content, DefaultMediaType.get(this.headers.get("Content-Type")));
        }
        return this.body;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }
}

