/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.ExecutionType;
import io.r2dbc.proxy.core.QueryInfo;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.util.annotation.Nullable;

public final class BatchCallbackHandler
extends CallbackHandlerSupport {
    private final Batch batch;
    private final ConnectionInfo connectionInfo;
    private final List<String> queries = new ArrayList<String>();

    public BatchCallbackHandler(Batch batch, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.batch = Assert.requireNonNull(batch, "batch must not be null");
        this.connectionInfo = Assert.requireNonNull(connectionInfo, "connectionInfo must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        if (this.isCommonMethod(methodName)) {
            return this.handleCommonMethod(methodName, this.batch, args, this.connectionInfo.getOriginalConnection());
        }
        Object result = this.proceedExecution(method, this.batch, args, this.proxyConfig.getListeners(), this.connectionInfo, null);
        if ("add".equals(methodName)) {
            this.queries.add((String)args[0]);
            return proxy;
        }
        if ("execute".equals(methodName)) {
            List<QueryInfo> queryInfoList = this.queries.stream().map(QueryInfo::new).collect(Collectors.toList());
            MutableQueryExecutionInfo execInfo = new MutableQueryExecutionInfo();
            execInfo.setType(ExecutionType.BATCH);
            execInfo.setQueries(queryInfoList);
            execInfo.setBatchSize(this.queries.size());
            execInfo.setMethod(method);
            execInfo.setMethodArgs(args);
            execInfo.setConnectionInfo(this.connectionInfo);
            Publisher publisher = (Publisher)result;
            return this.interceptQueryExecution((Publisher<? extends Result>)publisher, execInfo);
        }
        return result;
    }
}

