/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.proxy.callback;

import io.r2dbc.proxy.callback.CallbackHandlerSupport;
import io.r2dbc.proxy.callback.MutableQueryExecutionInfo;
import io.r2dbc.proxy.callback.ProxyConfig;
import io.r2dbc.proxy.callback.QueriesExecutionContext;
import io.r2dbc.proxy.callback.ResultInvocationSubscriber;
import io.r2dbc.proxy.core.ConnectionInfo;
import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.util.Assert;
import io.r2dbc.spi.Result;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

public final class ResultCallbackHandler
extends CallbackHandlerSupport {
    private final Result result;
    private final MutableQueryExecutionInfo queryExecutionInfo;
    private final QueriesExecutionContext queriesExecutionContext;

    public ResultCallbackHandler(Result result, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig, QueriesExecutionContext queriesExecutionContext) {
        super(proxyConfig);
        this.result = Assert.requireNonNull(result, "result must not be null");
        Assert.requireNonNull(queryExecutionInfo, "queryExecutionInfo must not be null");
        this.queryExecutionInfo = Assert.requireType(queryExecutionInfo, MutableQueryExecutionInfo.class, "queryExecutionInfo must be MutableQueryExecutionInfo");
        Assert.requireNonNull(queriesExecutionContext, "queriesExecutionContext must not be null");
        this.queriesExecutionContext = queriesExecutionContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.requireNonNull(proxy, "proxy must not be null");
        Assert.requireNonNull(method, "method must not be null");
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if ("unwrap".equals(methodName)) {
            return this.result;
        }
        if ("unwrapConnection".equals(methodName)) {
            return connectionInfo.getOriginalConnection();
        }
        Object invocationResult = this.proceedExecution(method, this.result, args, this.proxyConfig.getListeners(), connectionInfo, null);
        if ("map".equals(methodName) || "getRowsUpdated".equals(methodName)) {
            Function transformer = Operators.liftPublisher((pub, subscriber) -> new ResultInvocationSubscriber((CoreSubscriber<Object>)subscriber, this.queryExecutionInfo, this.proxyConfig, this.queriesExecutionContext));
            return Flux.from((Publisher)((Publisher)invocationResult)).transform(transformer);
        }
        return invocationResult;
    }
}

