/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class DoubleArrayCodec
extends AbstractArrayCodec<Double> {
    DoubleArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Double.class);
    }

    @Override
    public Parameter encodeNull() {
        return DoubleArrayCodec.createNull(PostgresqlObjectId.FLOAT8_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    Double doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readDouble();
    }

    @Override
    Double doDecodeText(String text) {
        return Double.parseDouble(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.FLOAT8_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return DoubleArrayCodec.create(PostgresqlObjectId.FLOAT8_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Double value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

