/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collections;
import java.util.function.Supplier;

final class IntegerArrayCodec
extends AbstractArrayCodec<Integer> {
    IntegerArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Integer.class);
    }

    @Override
    public Parameter encodeNull() {
        return IntegerArrayCodec.createNull(PostgresqlObjectId.INT4_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return Collections.singleton(PostgresqlObjectId.INT4_ARRAY);
    }

    @Override
    Integer doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readInt();
    }

    @Override
    Integer doDecodeText(String text) {
        return Integer.parseInt(text);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.INT4_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return IntegerArrayCodec.create(PostgresqlObjectId.INT4_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Integer value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

