/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.time.ZoneId;
import reactor.util.annotation.Nullable;

final class ZoneIdCodec
extends AbstractCodec<ZoneId> {
    private final StringCodec delegate;

    ZoneIdCodec(ByteBufAllocator byteBufAllocator) {
        super(ZoneId.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new StringCodec(byteBufAllocator);
    }

    @Override
    public Parameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    public Iterable<PostgresqlObjectId> getDataTypes() {
        return this.delegate.getDataTypes();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    ZoneId doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends ZoneId> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return ZoneId.of(((String)this.delegate.doDecode(buffer, dataType, format, String.class)).trim());
    }

    @Override
    Parameter doEncode(ZoneId value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(value.getId());
    }
}

